/*
 * Decompiled with CFR 0.152.
 */
package io.druid.server.initialization;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.jaxrs.json.JacksonJsonProvider;
import com.google.common.collect.Iterables;
import com.google.common.primitives.Ints;
import com.google.inject.Binder;
import com.google.inject.ConfigurationException;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Provides;
import com.google.inject.ProvisionException;
import com.google.inject.Scopes;
import com.google.inject.Singleton;
import com.google.inject.spi.Message;
import com.metamx.common.lifecycle.Lifecycle;
import com.metamx.common.logger.Logger;
import com.sun.jersey.api.core.DefaultResourceConfig;
import com.sun.jersey.api.core.ResourceConfig;
import com.sun.jersey.guice.JerseyServletModule;
import com.sun.jersey.guice.spi.container.servlet.GuiceContainer;
import com.sun.jersey.spi.container.servlet.WebConfig;
import io.druid.guice.Jerseys;
import io.druid.guice.JsonConfigProvider;
import io.druid.guice.LazySingleton;
import io.druid.guice.annotations.JSR311Resource;
import io.druid.guice.annotations.Json;
import io.druid.guice.annotations.Self;
import io.druid.server.DruidNode;
import io.druid.server.StatusResource;
import io.druid.server.initialization.JettyServerInitializer;
import io.druid.server.initialization.ServerConfig;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletException;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;

public class JettyServerModule
extends JerseyServletModule {
    private static final Logger log = new Logger(JettyServerModule.class);

    protected void configureServlets() {
        Binder binder = this.binder();
        JsonConfigProvider.bind((Binder)binder, (String)"druid.server.http", ServerConfig.class);
        binder.bind(GuiceContainer.class).to(DruidGuiceContainer.class);
        binder.bind(DruidGuiceContainer.class).in(Scopes.SINGLETON);
        this.serve("/*", new String[0]).with(DruidGuiceContainer.class);
        Jerseys.addResource((Binder)binder, StatusResource.class);
        binder.bind(StatusResource.class).in(LazySingleton.class);
    }

    @Provides
    @LazySingleton
    public Server getServer(Injector injector, Lifecycle lifecycle, @Self DruidNode node, ServerConfig config) {
        JettyServerInitializer initializer = (JettyServerInitializer)injector.getInstance(JettyServerInitializer.class);
        final Server server = JettyServerModule.makeJettyServer(node, config);
        try {
            initializer.initialize(server, injector);
        }
        catch (ConfigurationException e) {
            throw new ProvisionException(((Message)Iterables.getFirst((Iterable)e.getErrorMessages(), null)).getMessage());
        }
        lifecycle.addHandler(new Lifecycle.Handler(){

            public void start() throws Exception {
                server.start();
            }

            public void stop() {
                try {
                    server.stop();
                }
                catch (Exception e) {
                    log.warn((Throwable)e, "Unable to stop Jetty server.", new Object[0]);
                }
            }
        });
        return server;
    }

    @Provides
    @Singleton
    public JacksonJsonProvider getJacksonJsonProvider(@Json ObjectMapper objectMapper) {
        JacksonJsonProvider provider = new JacksonJsonProvider();
        provider.setMapper(objectMapper);
        return provider;
    }

    private static Server makeJettyServer(@Self DruidNode node, ServerConfig config) {
        QueuedThreadPool threadPool = new QueuedThreadPool();
        threadPool.setMinThreads(config.getNumThreads());
        threadPool.setMaxThreads(config.getNumThreads());
        Server server = new Server((ThreadPool)threadPool);
        ServerConnector connector = new ServerConnector(server);
        connector.setPort(node.getPort());
        connector.setIdleTimeout((long)Ints.checkedCast((long)config.getMaxIdleTime().toStandardDuration().getMillis()));
        server.setConnectors(new Connector[]{connector});
        return server;
    }

    public static class DruidGuiceContainer
    extends GuiceContainer {
        private final Set<Class<?>> resources;

        @Inject
        public DruidGuiceContainer(Injector injector, @JSR311Resource Set<Class<?>> resources) {
            super(injector);
            this.resources = resources;
        }

        protected ResourceConfig getDefaultResourceConfig(Map<String, Object> props, WebConfig webConfig) throws ServletException {
            return new DefaultResourceConfig(this.resources);
        }
    }
}

