/*
 * Decompiled with CFR 0.152.
 */
package io.druid.server.http;

import com.google.api.client.util.Lists;
import com.google.api.client.util.Maps;
import com.google.common.base.Function;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.metamx.common.MapUtils;
import io.druid.client.DruidDataSource;
import io.druid.client.DruidServer;
import io.druid.client.InventoryView;
import io.druid.timeline.DataSegment;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;

@Path(value="/druid/coordinator/v1/tiers")
public class TiersResource {
    private final InventoryView serverInventoryView;

    @Inject
    public TiersResource(InventoryView serverInventoryView) {
        this.serverInventoryView = serverInventoryView;
    }

    @GET
    @Produces(value={"application/json"})
    public Response getTiers(@QueryParam(value="simple") String simple) {
        Response.ResponseBuilder builder = Response.status((Response.Status)Response.Status.OK);
        if (simple != null) {
            HashMap metadata = Maps.newHashMap();
            for (DruidServer druidServer : this.serverInventoryView.getInventory()) {
                Long currSize;
                Map tierMetadata = (Map)metadata.get(druidServer.getTier());
                if (tierMetadata == null) {
                    tierMetadata = Maps.newHashMap();
                    metadata.put(druidServer.getTier(), tierMetadata);
                }
                tierMetadata.put("currSize", ((currSize = (Long)tierMetadata.get("currSize")) == null ? 0L : currSize) + druidServer.getCurrSize());
                Long maxSize = (Long)tierMetadata.get("maxSize");
                tierMetadata.put("maxSize", (maxSize == null ? 0L : maxSize) + druidServer.getMaxSize());
            }
            return builder.entity((Object)metadata).build();
        }
        HashSet tiers = Sets.newHashSet();
        for (DruidServer server : this.serverInventoryView.getInventory()) {
            tiers.add(server.getTier());
        }
        return builder.entity((Object)tiers).build();
    }

    @GET
    @Path(value="/{tierName}")
    @Produces(value={"application/json"})
    public Response getTierDatasources(@PathParam(value="tierName") String tierName, @QueryParam(value="simple") String simple) {
        if (simple != null) {
            HashBasedTable retVal = HashBasedTable.create();
            for (DruidServer druidServer : this.serverInventoryView.getInventory()) {
                if (!druidServer.getTier().equalsIgnoreCase(tierName)) continue;
                for (DataSegment dataSegment : druidServer.getSegments().values()) {
                    Map properties = (Map)retVal.get((Object)dataSegment.getDataSource(), (Object)dataSegment.getInterval());
                    if (properties == null) {
                        properties = Maps.newHashMap();
                        retVal.put((Object)dataSegment.getDataSource(), (Object)dataSegment.getInterval(), (Object)properties);
                    }
                    properties.put("size", MapUtils.getLong((Map)properties, (String)"size", (Long)0L) + dataSegment.getSize());
                    properties.put("count", MapUtils.getInt((Map)properties, (String)"count", (Integer)0) + 1);
                }
            }
            return Response.ok((Object)retVal.rowMap()).build();
        }
        HashSet retVal = Sets.newHashSet();
        for (DruidServer druidServer : this.serverInventoryView.getInventory()) {
            if (!druidServer.getTier().equalsIgnoreCase(tierName)) continue;
            retVal.addAll(Lists.newArrayList((Iterable)Iterables.transform(druidServer.getDataSources(), (Function)new Function<DruidDataSource, String>(){

                public String apply(DruidDataSource input) {
                    return input.getName();
                }
            })));
        }
        return Response.ok((Object)retVal).build();
    }
}

