/*
 * Decompiled with CFR 0.152.
 */
package io.druid.server.http;

import com.google.inject.Inject;
import io.druid.db.DatabaseRuleManager;
import io.druid.server.coordinator.rules.Rule;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;

@Path(value="/druid/coordinator/v1/rules")
public class RulesResource {
    private final DatabaseRuleManager databaseRuleManager;

    @Inject
    public RulesResource(DatabaseRuleManager databaseRuleManager) {
        this.databaseRuleManager = databaseRuleManager;
    }

    @GET
    @Produces(value={"application/json"})
    public Response getRules() {
        return Response.ok(this.databaseRuleManager.getAllRules()).build();
    }

    @GET
    @Path(value="/{dataSourceName}")
    @Produces(value={"application/json"})
    public Response getDatasourceRules(@PathParam(value="dataSourceName") String dataSourceName, @QueryParam(value="full") String full) {
        if (full != null) {
            return Response.ok(this.databaseRuleManager.getRulesWithDefault(dataSourceName)).build();
        }
        return Response.ok(this.databaseRuleManager.getRules(dataSourceName)).build();
    }

    @POST
    @Path(value="/{dataSourceName}")
    @Consumes(value={"application/json"})
    public Response setDatasourceRules(@PathParam(value="dataSourceName") String dataSourceName, List<Rule> rules) {
        if (this.databaseRuleManager.overrideRule(dataSourceName, rules)) {
            return Response.ok().build();
        }
        return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
    }
}

