/*
 * Decompiled with CFR 0.152.
 */
package io.druid.server.http;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import io.druid.client.DruidDataSource;
import io.druid.client.DruidServer;
import io.druid.client.InventoryView;
import io.druid.client.indexing.IndexingServiceClient;
import io.druid.db.DatabaseRuleManager;
import io.druid.db.DatabaseSegmentManager;
import io.druid.server.coordinator.DruidCoordinator;
import io.druid.server.coordinator.rules.LoadRule;
import io.druid.server.coordinator.rules.Rule;
import io.druid.timeline.DataSegment;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.Nullable;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.joda.time.Interval;

@Deprecated
@Path(value="/info")
public class InfoResource {
    private static final Function<DruidServer, Map<String, Object>> simplifyClusterFn = new Function<DruidServer, Map<String, Object>>(){

        public Map<String, Object> apply(DruidServer server) {
            return new ImmutableMap.Builder().put((Object)"host", (Object)server.getHost()).put((Object)"type", (Object)server.getType()).put((Object)"tier", (Object)server.getTier()).put((Object)"currSize", (Object)server.getCurrSize()).put((Object)"maxSize", (Object)server.getMaxSize()).put((Object)"segments", (Object)Collections2.transform(server.getSegments().values(), (Function)new Function<DataSegment, Map<String, Object>>(){

                public Map<String, Object> apply(DataSegment segment) {
                    return new ImmutableMap.Builder().put((Object)"id", (Object)segment.getIdentifier()).put((Object)"dataSource", (Object)segment.getDataSource()).put((Object)"interval", (Object)segment.getInterval().toString()).put((Object)"version", (Object)segment.getVersion()).put((Object)"size", (Object)segment.getSize()).build();
                }
            })).build();
        }
    };
    private final DruidCoordinator coordinator;
    private final InventoryView serverInventoryView;
    private final DatabaseSegmentManager databaseSegmentManager;
    private final DatabaseRuleManager databaseRuleManager;
    private final IndexingServiceClient indexingServiceClient;
    private final ObjectMapper jsonMapper;

    @Inject
    public InfoResource(DruidCoordinator coordinator, InventoryView serverInventoryView, DatabaseSegmentManager databaseSegmentManager, DatabaseRuleManager databaseRuleManager, @Nullable IndexingServiceClient indexingServiceClient, ObjectMapper jsonMapper) {
        this.coordinator = coordinator;
        this.serverInventoryView = serverInventoryView;
        this.databaseSegmentManager = databaseSegmentManager;
        this.databaseRuleManager = databaseRuleManager;
        this.indexingServiceClient = indexingServiceClient;
        this.jsonMapper = jsonMapper;
    }

    @GET
    @Path(value="/coordinator")
    @Produces(value={"application/json"})
    public Response getMaster() {
        return Response.status((Response.Status)Response.Status.OK).entity((Object)this.coordinator.getCurrentLeader()).build();
    }

    @GET
    @Path(value="/cluster")
    @Produces(value={"application/json"})
    public Response getClusterInfo(@QueryParam(value="full") String full) {
        if (full != null) {
            return Response.ok(this.serverInventoryView.getInventory()).build();
        }
        return Response.ok((Object)Lists.newArrayList((Iterable)Iterables.transform(this.serverInventoryView.getInventory(), simplifyClusterFn))).build();
    }

    @GET
    @Path(value="/servers")
    @Produces(value={"application/json"})
    public Response getClusterServers(@QueryParam(value="full") String full) {
        Response.ResponseBuilder builder = Response.status((Response.Status)Response.Status.OK);
        if (full != null) {
            return builder.entity((Object)Lists.newArrayList(this.serverInventoryView.getInventory())).build();
        }
        return builder.entity((Object)Lists.newArrayList((Iterable)Iterables.transform(this.serverInventoryView.getInventory(), (Function)new Function<DruidServer, String>(){

            public String apply(DruidServer druidServer) {
                return druidServer.getHost();
            }
        }))).build();
    }

    @GET
    @Path(value="/servers/{serverName}")
    @Produces(value={"application/json"})
    public Response getServer(@PathParam(value="serverName") String serverName) {
        Response.ResponseBuilder builder = Response.status((Response.Status)Response.Status.OK);
        DruidServer server = this.serverInventoryView.getInventoryValue(serverName);
        if (server == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        return builder.status(Response.Status.OK).entity((Object)server).build();
    }

    @GET
    @Path(value="/servers/{serverName}/segments")
    @Produces(value={"application/json"})
    public Response getServerSegments(@PathParam(value="serverName") String serverName, @QueryParam(value="full") String full) {
        Response.ResponseBuilder builder = Response.status((Response.Status)Response.Status.OK);
        DruidServer server = this.serverInventoryView.getInventoryValue(serverName);
        if (server == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        if (full != null) {
            return builder.entity(server.getSegments().values()).build();
        }
        return builder.entity((Object)Collections2.transform(server.getSegments().values(), (Function)new Function<DataSegment, String>(){

            public String apply(@Nullable DataSegment segment) {
                return segment.getIdentifier();
            }
        })).build();
    }

    @GET
    @Path(value="/servers/{serverName}/segments/{segmentId}")
    @Produces(value={"application/json"})
    public Response getServerSegment(@PathParam(value="serverName") String serverName, @PathParam(value="segmentId") String segmentId) {
        DruidServer server = this.serverInventoryView.getInventoryValue(serverName);
        if (server == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        DataSegment segment = server.getSegment(segmentId);
        if (segment == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        return Response.status((Response.Status)Response.Status.OK).entity((Object)segment).build();
    }

    @GET
    @Path(value="/segments")
    @Produces(value={"application/json"})
    public Response getClusterSegments(@QueryParam(value="full") String full) {
        Response.ResponseBuilder builder = Response.status((Response.Status)Response.Status.OK);
        if (full != null) {
            return builder.entity((Object)Lists.newArrayList((Iterable)Iterables.concat((Iterable)Iterables.transform(this.serverInventoryView.getInventory(), (Function)new Function<DruidServer, Iterable<DataSegment>>(){

                public Iterable<DataSegment> apply(@Nullable DruidServer druidServer) {
                    return druidServer.getSegments().values();
                }
            })))).build();
        }
        return builder.entity((Object)Lists.newArrayList((Iterable)Iterables.concat((Iterable)Iterables.transform(this.serverInventoryView.getInventory(), (Function)new Function<DruidServer, Iterable<String>>(){

            public Iterable<String> apply(@Nullable DruidServer druidServer) {
                return Collections2.transform(druidServer.getSegments().values(), (Function)new Function<DataSegment, String>(){

                    public String apply(@Nullable DataSegment segment) {
                        return segment.getIdentifier();
                    }
                });
            }
        })))).build();
    }

    @GET
    @Path(value="/segments/{segmentId}")
    @Produces(value={"application/json"})
    public Response getClusterSegment(@PathParam(value="segmentId") String segmentId) {
        for (DruidServer server : this.serverInventoryView.getInventory()) {
            if (!server.getSegments().containsKey(segmentId)) continue;
            return Response.status((Response.Status)Response.Status.OK).entity((Object)server.getSegments().get(segmentId)).build();
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }

    @GET
    @Path(value="/tiers")
    @Produces(value={"application/json"})
    public Response getTiers() {
        HashSet tiers = Sets.newHashSet();
        for (DruidServer server : this.serverInventoryView.getInventory()) {
            tiers.add(server.getTier());
        }
        return Response.status((Response.Status)Response.Status.OK).entity((Object)tiers).build();
    }

    @GET
    @Path(value="/rules")
    @Produces(value={"application/json"})
    public Response getRules() {
        return Response.ok().entity((Object)Maps.transformValues(this.databaseRuleManager.getAllRules(), (Function)new Function<List<Rule>, Object>(){

            public Object apply(List<Rule> rules) {
                return Lists.transform(rules, (Function)new Function<Rule, Object>(){

                    public Object apply(Rule rule) {
                        if (rule instanceof LoadRule) {
                            Map newRule = (Map)InfoResource.this.jsonMapper.convertValue((Object)rule, (TypeReference)new TypeReference<Map<String, Object>>(){});
                            HashSet tiers = Sets.newHashSet(((LoadRule)rule).getTieredReplicants().keySet());
                            tiers.remove("_default_tier");
                            String tier = "_default_tier";
                            if (!tiers.isEmpty()) {
                                tier = (String)tiers.iterator().next();
                            }
                            newRule.put("tier", tier);
                            newRule.put("replicants", ((LoadRule)rule).getNumReplicants(tier));
                            return newRule;
                        }
                        return rule;
                    }
                });
            }
        })).build();
    }

    @GET
    @Path(value="/rules/{dataSourceName}")
    @Produces(value={"application/json"})
    public Response getDatasourceRules(@PathParam(value="dataSourceName") String dataSourceName, @QueryParam(value="full") String full) {
        if (full != null) {
            return Response.ok(this.databaseRuleManager.getRulesWithDefault(dataSourceName)).build();
        }
        return Response.ok(this.databaseRuleManager.getRules(dataSourceName)).build();
    }

    @POST
    @Path(value="/rules/{dataSourceName}")
    @Consumes(value={"application/json"})
    public Response setDatasourceRules(@PathParam(value="dataSourceName") String dataSourceName, List<Rule> rules) {
        if (this.databaseRuleManager.overrideRule(dataSourceName, rules)) {
            return Response.status((Response.Status)Response.Status.OK).build();
        }
        return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
    }

    @GET
    @Path(value="/datasources")
    @Produces(value={"application/json"})
    public Response getQueryableDataSources(@QueryParam(value="full") String full) {
        Response.ResponseBuilder builder = Response.status((Response.Status)Response.Status.OK);
        if (full != null) {
            return builder.entity(this.getDataSources()).build();
        }
        return builder.entity((Object)Lists.newArrayList((Iterable)Iterables.transform(this.getDataSources(), (Function)new Function<DruidDataSource, String>(){

            public String apply(@Nullable DruidDataSource dataSource) {
                return dataSource.getName();
            }
        }))).build();
    }

    @GET
    @Path(value="/datasources/{dataSourceName}")
    @Produces(value={"application/json"})
    public Response getTheDataSource(@PathParam(value="dataSourceName") String dataSourceName) {
        DruidDataSource dataSource = this.getDataSource(dataSourceName.toLowerCase());
        if (dataSource == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        return Response.ok((Object)dataSource).build();
    }

    @DELETE
    @Path(value="/datasources/{dataSourceName}")
    public Response deleteDataSource(@PathParam(value="dataSourceName") String dataSourceName, @QueryParam(value="kill") String kill, @QueryParam(value="interval") String interval) {
        if (this.indexingServiceClient == null) {
            return Response.status((Response.Status)Response.Status.OK).entity((Object)ImmutableMap.of((Object)"error", (Object)"no indexing service found")).build();
        }
        if (kill != null && Boolean.valueOf(kill).booleanValue()) {
            this.indexingServiceClient.killSegments(dataSourceName, new Interval((Object)interval));
        } else if (!this.databaseSegmentManager.removeDatasource(dataSourceName)) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    @POST
    @Path(value="/datasources/{dataSourceName}")
    @Consumes(value={"application/json"})
    public Response enableDataSource(@PathParam(value="dataSourceName") String dataSourceName) {
        if (!this.databaseSegmentManager.enableDatasource(dataSourceName)) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    @GET
    @Path(value="/datasources/{dataSourceName}/segments")
    @Produces(value={"application/json"})
    public Response getSegmentDataSourceSegments(@PathParam(value="dataSourceName") String dataSourceName, @QueryParam(value="full") String full) {
        DruidDataSource dataSource = this.getDataSource(dataSourceName.toLowerCase());
        if (dataSource == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        Response.ResponseBuilder builder = Response.status((Response.Status)Response.Status.OK);
        if (full != null) {
            return builder.entity(dataSource.getSegments()).build();
        }
        return builder.entity((Object)Iterables.transform(dataSource.getSegments(), (Function)new Function<DataSegment, Object>(){

            public Object apply(@Nullable DataSegment segment) {
                return segment.getIdentifier();
            }
        })).build();
    }

    @GET
    @Path(value="/datasources/{dataSourceName}/segments/{segmentId}")
    @Produces(value={"application/json"})
    public Response getSegmentDataSourceSegment(@PathParam(value="dataSourceName") String dataSourceName, @PathParam(value="segmentId") String segmentId) {
        DruidDataSource dataSource = this.getDataSource(dataSourceName.toLowerCase());
        if (dataSource == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        for (DataSegment segment : dataSource.getSegments()) {
            if (!segment.getIdentifier().equalsIgnoreCase(segmentId)) continue;
            return Response.status((Response.Status)Response.Status.OK).entity((Object)segment).build();
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }

    @DELETE
    @Path(value="/datasources/{dataSourceName}/segments/{segmentId}")
    public Response deleteDatasourceSegment(@PathParam(value="dataSourceName") String dataSourceName, @PathParam(value="segmentId") String segmentId) {
        if (!this.databaseSegmentManager.removeSegment(dataSourceName, segmentId)) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    @POST
    @Path(value="/datasources/{dataSourceName}/segments/{segmentId}")
    @Consumes(value={"application/json"})
    public Response enableDatasourceSegment(@PathParam(value="dataSourceName") String dataSourceName, @PathParam(value="segmentId") String segmentId) {
        if (!this.databaseSegmentManager.enableSegment(segmentId)) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    private DruidDataSource getDataSource(final String dataSourceName) {
        Iterable dataSources = Iterables.concat((Iterable[])new Iterable[]{Iterables.transform(this.serverInventoryView.getInventory(), (Function)new Function<DruidServer, DruidDataSource>(){

            public DruidDataSource apply(@Nullable DruidServer input) {
                return input.getDataSource(dataSourceName);
            }
        })});
        ArrayList validDataSources = Lists.newArrayList();
        for (DruidDataSource dataSource : dataSources) {
            if (dataSource == null) continue;
            validDataSources.add(dataSource);
        }
        if (validDataSources.isEmpty()) {
            return null;
        }
        HashMap segmentMap = Maps.newHashMap();
        for (DruidDataSource dataSource : validDataSources) {
            if (dataSource == null) continue;
            Set<DataSegment> segments = dataSource.getSegments();
            for (DataSegment segment : segments) {
                segmentMap.put(segment.getIdentifier(), segment);
            }
        }
        return new DruidDataSource(dataSourceName, (Map<String, String>)ImmutableMap.of()).addSegments(segmentMap);
    }

    private Set<DruidDataSource> getDataSources() {
        TreeSet dataSources = Sets.newTreeSet((Comparator)new Comparator<DruidDataSource>(){

            @Override
            public int compare(DruidDataSource druidDataSource, DruidDataSource druidDataSource1) {
                return druidDataSource.getName().compareTo(druidDataSource1.getName());
            }
        });
        dataSources.addAll(Lists.newArrayList((Iterable)Iterables.concat((Iterable)Iterables.transform(this.serverInventoryView.getInventory(), (Function)new Function<DruidServer, Iterable<DruidDataSource>>(){

            public Iterable<DruidDataSource> apply(@Nullable DruidServer input) {
                return input.getDataSources();
            }
        }))));
        return dataSources;
    }

    @GET
    @Path(value="/db/datasources")
    @Produces(value={"application/json"})
    public Response getDatabaseDataSources(@QueryParam(value="full") String full, @QueryParam(value="includeDisabled") String includeDisabled) {
        Response.ResponseBuilder builder = Response.status((Response.Status)Response.Status.OK);
        if (includeDisabled != null) {
            return builder.entity(this.databaseSegmentManager.getAllDatasourceNames()).build();
        }
        if (full != null) {
            return builder.entity(this.databaseSegmentManager.getInventory()).build();
        }
        ArrayList dataSourceNames = Lists.newArrayList((Iterable)Iterables.transform(this.databaseSegmentManager.getInventory(), (Function)new Function<DruidDataSource, String>(){

            public String apply(@Nullable DruidDataSource dataSource) {
                return dataSource.getName();
            }
        }));
        Collections.sort(dataSourceNames);
        return builder.entity((Object)dataSourceNames).build();
    }

    @GET
    @Path(value="/db/datasources/{dataSourceName}")
    @Produces(value={"application/json"})
    public Response getDatabaseSegmentDataSource(@PathParam(value="dataSourceName") String dataSourceName) {
        DruidDataSource dataSource = this.databaseSegmentManager.getInventoryValue(dataSourceName);
        if (dataSource == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        return Response.status((Response.Status)Response.Status.OK).entity((Object)dataSource).build();
    }

    @GET
    @Path(value="/db/datasources/{dataSourceName}/segments")
    @Produces(value={"application/json"})
    public Response getDatabaseSegmentDataSourceSegments(@PathParam(value="dataSourceName") String dataSourceName, @QueryParam(value="full") String full) {
        DruidDataSource dataSource = this.databaseSegmentManager.getInventoryValue(dataSourceName);
        if (dataSource == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        Response.ResponseBuilder builder = Response.status((Response.Status)Response.Status.OK);
        if (full != null) {
            return builder.entity(dataSource.getSegments()).build();
        }
        return builder.entity((Object)Iterables.transform(dataSource.getSegments(), (Function)new Function<DataSegment, Object>(){

            public Object apply(@Nullable DataSegment segment) {
                return segment.getIdentifier();
            }
        })).build();
    }

    @GET
    @Path(value="/db/datasources/{dataSourceName}/segments/{segmentId}")
    @Produces(value={"application/json"})
    public Response getDatabaseSegmentDataSourceSegment(@PathParam(value="dataSourceName") String dataSourceName, @PathParam(value="segmentId") String segmentId) {
        DruidDataSource dataSource = this.databaseSegmentManager.getInventoryValue(dataSourceName);
        if (dataSource == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        for (DataSegment segment : dataSource.getSegments()) {
            if (!segment.getIdentifier().equalsIgnoreCase(segmentId)) continue;
            return Response.status((Response.Status)Response.Status.OK).entity((Object)segment).build();
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }
}

