/*
 * Decompiled with CFR 0.152.
 */
package io.druid.server.http;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import io.druid.server.coordinator.DruidCoordinator;
import io.druid.server.coordinator.LoadQueuePeon;
import io.druid.timeline.DataSegment;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;

@Path(value="/druid/coordinator/v1")
public class CoordinatorResource {
    private final DruidCoordinator coordinator;

    @Inject
    public CoordinatorResource(DruidCoordinator coordinator) {
        this.coordinator = coordinator;
    }

    @GET
    @Path(value="/leader")
    @Produces(value={"application/json"})
    public Response getLeader() {
        return Response.ok((Object)this.coordinator.getCurrentLeader()).build();
    }

    @GET
    @Path(value="/loadstatus")
    @Produces(value={"application/json"})
    public Response getLoadStatus(@QueryParam(value="simple") String simple, @QueryParam(value="full") String full) {
        if (simple != null) {
            return Response.ok(this.coordinator.getSegmentAvailability()).build();
        }
        if (full != null) {
            return Response.ok(this.coordinator.getReplicationStatus()).build();
        }
        return Response.ok(this.coordinator.getLoadStatus()).build();
    }

    @GET
    @Path(value="/loadqueue")
    @Produces(value={"application/json"})
    public Response getLoadQueue(@QueryParam(value="simple") String simple, @QueryParam(value="full") String full) {
        if (simple != null) {
            return Response.ok((Object)Maps.transformValues(this.coordinator.getLoadManagementPeons(), (Function)new Function<LoadQueuePeon, Object>(){

                public Object apply(LoadQueuePeon input) {
                    long loadSize = 0L;
                    for (DataSegment dataSegment : input.getSegmentsToLoad()) {
                        loadSize += dataSegment.getSize();
                    }
                    long dropSize = 0L;
                    for (DataSegment dataSegment : input.getSegmentsToDrop()) {
                        dropSize += dataSegment.getSize();
                    }
                    return new ImmutableMap.Builder().put((Object)"segmentsToLoad", (Object)input.getSegmentsToLoad().size()).put((Object)"segmentsToDrop", (Object)input.getSegmentsToDrop().size()).put((Object)"segmentsToLoadSize", (Object)loadSize).put((Object)"segmentsToDropSize", (Object)dropSize).build();
                }
            })).build();
        }
        if (full != null) {
            return Response.ok(this.coordinator.getLoadManagementPeons()).build();
        }
        return Response.ok((Object)Maps.transformValues(this.coordinator.getLoadManagementPeons(), (Function)new Function<LoadQueuePeon, Object>(){

            public Object apply(LoadQueuePeon input) {
                return new ImmutableMap.Builder().put((Object)"segmentsToLoad", (Object)Collections2.transform(input.getSegmentsToLoad(), (Function)new Function<DataSegment, Object>(){

                    public String apply(DataSegment segment) {
                        return segment.getIdentifier();
                    }
                })).put((Object)"segmentsToDrop", (Object)Collections2.transform(input.getSegmentsToDrop(), (Function)new Function<DataSegment, Object>(){

                    public String apply(DataSegment segment) {
                        return segment.getIdentifier();
                    }
                })).build();
            }
        })).build();
    }
}

