/*
 * Decompiled with CFR 0.152.
 */
package io.druid.server.http;

import io.druid.common.config.JacksonConfigManager;
import io.druid.server.coordinator.CoordinatorDynamicConfig;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Path(value="/druid/coordinator/v1/config")
public class CoordinatorDynamicConfigsResource {
    private final JacksonConfigManager manager;

    @Inject
    public CoordinatorDynamicConfigsResource(JacksonConfigManager manager) {
        this.manager = manager;
    }

    @GET
    @Produces(value={"application/json"})
    public Response getDynamicConfigs() {
        return Response.ok(this.manager.watch("coordinator.config", CoordinatorDynamicConfig.class).get()).build();
    }

    @POST
    @Consumes(value={"application/json"})
    public Response setDynamicConfigs(CoordinatorDynamicConfig dynamicConfig) {
        if (!this.manager.set("coordinator.config", (Object)dynamicConfig)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        return Response.ok().build();
    }
}

