/*
 * Decompiled with CFR 0.152.
 */
package io.druid.server.coordinator.helper;

import com.metamx.emitter.EmittingLogger;
import io.druid.client.indexing.IndexingServiceClient;
import io.druid.server.coordinator.DatasourceWhitelist;
import io.druid.server.coordinator.DruidCoordinatorRuntimeParams;
import io.druid.server.coordinator.helper.DruidCoordinatorHelper;
import io.druid.timeline.DataSegment;
import java.util.concurrent.atomic.AtomicReference;

public class DruidCoordinatorVersionConverter
implements DruidCoordinatorHelper {
    private static final EmittingLogger log = new EmittingLogger(DruidCoordinatorVersionConverter.class);
    private final IndexingServiceClient indexingServiceClient;
    private final AtomicReference<DatasourceWhitelist> whitelistRef;

    public DruidCoordinatorVersionConverter(IndexingServiceClient indexingServiceClient, AtomicReference<DatasourceWhitelist> whitelistRef) {
        this.indexingServiceClient = indexingServiceClient;
        this.whitelistRef = whitelistRef;
    }

    @Override
    public DruidCoordinatorRuntimeParams run(DruidCoordinatorRuntimeParams params) {
        DatasourceWhitelist whitelist = this.whitelistRef.get();
        for (DataSegment dataSegment : params.getAvailableSegments()) {
            Integer binaryVersion;
            if (whitelist != null && !whitelist.contains(dataSegment.getDataSource()) || (binaryVersion = dataSegment.getBinaryVersion()) != null && binaryVersion >= 9) continue;
            log.info("Upgrading version on segment[%s]", new Object[]{dataSegment.getIdentifier()});
            this.indexingServiceClient.upgradeSegment(dataSegment);
        }
        return params;
    }
}

