/*
 * Decompiled with CFR 0.152.
 */
package io.druid.server.coordinator.helper;

import com.google.common.collect.Maps;
import com.google.common.collect.MinMaxPriorityQueue;
import com.metamx.common.guava.Comparators;
import io.druid.client.ImmutableDruidDataSource;
import io.druid.client.ImmutableDruidServer;
import io.druid.server.coordinator.CoordinatorStats;
import io.druid.server.coordinator.DruidCluster;
import io.druid.server.coordinator.DruidCoordinator;
import io.druid.server.coordinator.DruidCoordinatorRuntimeParams;
import io.druid.server.coordinator.ServerHolder;
import io.druid.server.coordinator.helper.DruidCoordinatorHelper;
import io.druid.timeline.DataSegment;
import io.druid.timeline.TimelineObjectHolder;
import io.druid.timeline.VersionedIntervalTimeline;
import java.util.HashMap;

public class DruidCoordinatorCleanupOvershadowed
implements DruidCoordinatorHelper {
    private final DruidCoordinator coordinator;

    public DruidCoordinatorCleanupOvershadowed(DruidCoordinator coordinator) {
        this.coordinator = coordinator;
    }

    @Override
    public DruidCoordinatorRuntimeParams run(DruidCoordinatorRuntimeParams params) {
        CoordinatorStats stats = new CoordinatorStats();
        if (params.hasDeletionWaitTimeElapsed()) {
            DruidCluster cluster = params.getDruidCluster();
            HashMap timelines = Maps.newHashMap();
            for (MinMaxPriorityQueue<ServerHolder> serverHolders : cluster.getSortedServersByTier()) {
                for (ServerHolder serverHolder : serverHolders) {
                    ImmutableDruidServer server = serverHolder.getServer();
                    for (ImmutableDruidDataSource dataSource : server.getDataSources()) {
                        VersionedIntervalTimeline timeline = (VersionedIntervalTimeline)timelines.get(dataSource.getName());
                        if (timeline == null) {
                            timeline = new VersionedIntervalTimeline(Comparators.comparable());
                            timelines.put(dataSource.getName(), timeline);
                        }
                        for (DataSegment segment : dataSource.getSegments()) {
                            timeline.add(segment.getInterval(), (Object)segment.getVersion(), segment.getShardSpec().createChunk((Object)segment));
                        }
                    }
                }
            }
            for (VersionedIntervalTimeline timeline : timelines.values()) {
                for (TimelineObjectHolder holder : timeline.findOvershadowed()) {
                    for (DataSegment dataSegment : holder.getObject().payloads()) {
                        this.coordinator.removeSegment(dataSegment);
                        stats.addToGlobalStat("overShadowedCount", 1L);
                    }
                }
            }
        }
        return params.buildFromExisting().withCoordinatorStats(stats).build();
    }
}

