/*
 * Decompiled with CFR 0.152.
 */
package io.druid.server.coordinator;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.metamx.common.guava.Comparators;
import com.metamx.emitter.service.ServiceEmitter;
import io.druid.client.DruidDataSource;
import io.druid.db.DatabaseRuleManager;
import io.druid.server.coordinator.BalancerStrategyFactory;
import io.druid.server.coordinator.CoordinatorDynamicConfig;
import io.druid.server.coordinator.CoordinatorStats;
import io.druid.server.coordinator.CostBalancerStrategyFactory;
import io.druid.server.coordinator.DruidCluster;
import io.druid.server.coordinator.LoadQueuePeon;
import io.druid.server.coordinator.ReplicationThrottler;
import io.druid.server.coordinator.SegmentReplicantLookup;
import io.druid.timeline.DataSegment;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import org.joda.time.DateTime;

public class DruidCoordinatorRuntimeParams {
    private final long startTime;
    private final DruidCluster druidCluster;
    private final DatabaseRuleManager databaseRuleManager;
    private final SegmentReplicantLookup segmentReplicantLookup;
    private final Set<DruidDataSource> dataSources;
    private final Set<DataSegment> availableSegments;
    private final Map<String, LoadQueuePeon> loadManagementPeons;
    private final ReplicationThrottler replicationManager;
    private final ServiceEmitter emitter;
    private final CoordinatorDynamicConfig coordinatorDynamicConfig;
    private final CoordinatorStats stats;
    private final DateTime balancerReferenceTimestamp;
    private final BalancerStrategyFactory strategyFactory;

    public DruidCoordinatorRuntimeParams(long startTime, DruidCluster druidCluster, DatabaseRuleManager databaseRuleManager, SegmentReplicantLookup segmentReplicantLookup, Set<DruidDataSource> dataSources, Set<DataSegment> availableSegments, Map<String, LoadQueuePeon> loadManagementPeons, ReplicationThrottler replicationManager, ServiceEmitter emitter, CoordinatorDynamicConfig coordinatorDynamicConfig, CoordinatorStats stats, DateTime balancerReferenceTimestamp, BalancerStrategyFactory strategyFactory) {
        this.startTime = startTime;
        this.druidCluster = druidCluster;
        this.databaseRuleManager = databaseRuleManager;
        this.segmentReplicantLookup = segmentReplicantLookup;
        this.dataSources = dataSources;
        this.availableSegments = availableSegments;
        this.loadManagementPeons = loadManagementPeons;
        this.replicationManager = replicationManager;
        this.emitter = emitter;
        this.coordinatorDynamicConfig = coordinatorDynamicConfig;
        this.stats = stats;
        this.balancerReferenceTimestamp = balancerReferenceTimestamp;
        this.strategyFactory = strategyFactory;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public DruidCluster getDruidCluster() {
        return this.druidCluster;
    }

    public DatabaseRuleManager getDatabaseRuleManager() {
        return this.databaseRuleManager;
    }

    public SegmentReplicantLookup getSegmentReplicantLookup() {
        return this.segmentReplicantLookup;
    }

    public Set<DruidDataSource> getDataSources() {
        return this.dataSources;
    }

    public Set<DataSegment> getAvailableSegments() {
        return this.availableSegments;
    }

    public Map<String, LoadQueuePeon> getLoadManagementPeons() {
        return this.loadManagementPeons;
    }

    public ReplicationThrottler getReplicationManager() {
        return this.replicationManager;
    }

    public ServiceEmitter getEmitter() {
        return this.emitter;
    }

    public CoordinatorDynamicConfig getCoordinatorDynamicConfig() {
        return this.coordinatorDynamicConfig;
    }

    public CoordinatorStats getCoordinatorStats() {
        return this.stats;
    }

    public DateTime getBalancerReferenceTimestamp() {
        return this.balancerReferenceTimestamp;
    }

    public BalancerStrategyFactory getBalancerStrategyFactory() {
        return this.strategyFactory;
    }

    public boolean hasDeletionWaitTimeElapsed() {
        return System.currentTimeMillis() - this.getStartTime() > this.coordinatorDynamicConfig.getMillisToWaitBeforeDeleting();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder buildFromExisting() {
        return new Builder(this.startTime, this.druidCluster, this.databaseRuleManager, this.segmentReplicantLookup, this.dataSources, this.availableSegments, this.loadManagementPeons, this.replicationManager, this.emitter, this.coordinatorDynamicConfig, this.stats, this.balancerReferenceTimestamp, this.strategyFactory);
    }

    public static class Builder {
        private long startTime;
        private DruidCluster druidCluster;
        private DatabaseRuleManager databaseRuleManager;
        private SegmentReplicantLookup segmentReplicantLookup;
        private final Set<DruidDataSource> dataSources;
        private final Set<DataSegment> availableSegments;
        private final Map<String, LoadQueuePeon> loadManagementPeons;
        private ReplicationThrottler replicationManager;
        private ServiceEmitter emitter;
        private CoordinatorDynamicConfig coordinatorDynamicConfig;
        private CoordinatorStats stats;
        private DateTime balancerReferenceTimestamp;
        private BalancerStrategyFactory strategyFactory;

        Builder() {
            this.startTime = 0L;
            this.druidCluster = null;
            this.databaseRuleManager = null;
            this.segmentReplicantLookup = null;
            this.dataSources = Sets.newHashSet();
            this.availableSegments = Sets.newTreeSet((Comparator)Comparators.inverse((Comparator)DataSegment.bucketMonthComparator()));
            this.loadManagementPeons = Maps.newHashMap();
            this.replicationManager = null;
            this.emitter = null;
            this.stats = new CoordinatorStats();
            this.coordinatorDynamicConfig = new CoordinatorDynamicConfig.Builder().build();
            this.balancerReferenceTimestamp = DateTime.now();
            this.strategyFactory = new CostBalancerStrategyFactory(1);
        }

        Builder(long startTime, DruidCluster cluster, DatabaseRuleManager databaseRuleManager, SegmentReplicantLookup segmentReplicantLookup, Set<DruidDataSource> dataSources, Set<DataSegment> availableSegments, Map<String, LoadQueuePeon> loadManagementPeons, ReplicationThrottler replicationManager, ServiceEmitter emitter, CoordinatorDynamicConfig coordinatorDynamicConfig, CoordinatorStats stats, DateTime balancerReferenceTimestamp, BalancerStrategyFactory strategyFactory) {
            this.startTime = startTime;
            this.druidCluster = cluster;
            this.databaseRuleManager = databaseRuleManager;
            this.segmentReplicantLookup = segmentReplicantLookup;
            this.dataSources = dataSources;
            this.availableSegments = availableSegments;
            this.loadManagementPeons = loadManagementPeons;
            this.replicationManager = replicationManager;
            this.emitter = emitter;
            this.coordinatorDynamicConfig = coordinatorDynamicConfig;
            this.stats = stats;
            this.balancerReferenceTimestamp = balancerReferenceTimestamp;
            this.strategyFactory = strategyFactory;
        }

        public DruidCoordinatorRuntimeParams build() {
            return new DruidCoordinatorRuntimeParams(this.startTime, this.druidCluster, this.databaseRuleManager, this.segmentReplicantLookup, this.dataSources, this.availableSegments, this.loadManagementPeons, this.replicationManager, this.emitter, this.coordinatorDynamicConfig, this.stats, this.balancerReferenceTimestamp, this.strategyFactory);
        }

        public Builder withStartTime(long time) {
            this.startTime = time;
            return this;
        }

        public Builder withDruidCluster(DruidCluster cluster) {
            this.druidCluster = cluster;
            return this;
        }

        public Builder withDatabaseRuleManager(DatabaseRuleManager databaseRuleManager) {
            this.databaseRuleManager = databaseRuleManager;
            return this;
        }

        public Builder withSegmentReplicantLookup(SegmentReplicantLookup lookup) {
            this.segmentReplicantLookup = lookup;
            return this;
        }

        public Builder withDatasources(Collection<DruidDataSource> dataSourcesCollection) {
            this.dataSources.addAll(Collections.unmodifiableCollection(dataSourcesCollection));
            return this;
        }

        public Builder withAvailableSegments(Collection<DataSegment> availableSegmentsCollection) {
            this.availableSegments.addAll(Collections.unmodifiableCollection(availableSegmentsCollection));
            return this;
        }

        public Builder withLoadManagementPeons(Map<String, LoadQueuePeon> loadManagementPeonsCollection) {
            this.loadManagementPeons.putAll(Collections.unmodifiableMap(loadManagementPeonsCollection));
            return this;
        }

        public Builder withReplicationManager(ReplicationThrottler replicationManager) {
            this.replicationManager = replicationManager;
            return this;
        }

        public Builder withEmitter(ServiceEmitter emitter) {
            this.emitter = emitter;
            return this;
        }

        public Builder withCoordinatorStats(CoordinatorStats stats) {
            this.stats.accumulate(stats);
            return this;
        }

        public Builder withDynamicConfigs(CoordinatorDynamicConfig configs) {
            this.coordinatorDynamicConfig = configs;
            return this;
        }

        public Builder withBalancerReferenceTimestamp(DateTime balancerReferenceTimestamp) {
            this.balancerReferenceTimestamp = balancerReferenceTimestamp;
            return this;
        }

        public Builder withBalancerStrategyFactory(BalancerStrategyFactory strategyFactory) {
            this.strategyFactory = strategyFactory;
            return this;
        }
    }
}

