/*
 * Decompiled with CFR 0.152.
 */
package io.druid.server.coordinator;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.metamx.common.IAE;
import com.metamx.common.Pair;
import com.metamx.common.concurrent.ScheduledExecutorFactory;
import com.metamx.common.concurrent.ScheduledExecutors;
import com.metamx.common.guava.CloseQuietly;
import com.metamx.common.guava.Comparators;
import com.metamx.common.guava.FunctionalIterable;
import com.metamx.common.lifecycle.LifecycleStart;
import com.metamx.common.lifecycle.LifecycleStop;
import com.metamx.emitter.EmittingLogger;
import com.metamx.emitter.service.ServiceEmitter;
import com.metamx.emitter.service.ServiceMetricEvent;
import io.druid.client.DruidDataSource;
import io.druid.client.DruidServer;
import io.druid.client.ImmutableDruidDataSource;
import io.druid.client.ImmutableDruidServer;
import io.druid.client.ServerInventoryView;
import io.druid.client.indexing.IndexingServiceClient;
import io.druid.collections.CountingMap;
import io.druid.common.config.JacksonConfigManager;
import io.druid.concurrent.Execs;
import io.druid.curator.discovery.ServiceAnnouncer;
import io.druid.db.DatabaseRuleManager;
import io.druid.db.DatabaseSegmentManager;
import io.druid.guice.ManageLifecycle;
import io.druid.guice.annotations.Self;
import io.druid.server.DruidNode;
import io.druid.server.coordinator.CoordinatorDynamicConfig;
import io.druid.server.coordinator.CoordinatorStats;
import io.druid.server.coordinator.CostBalancerStrategyFactory;
import io.druid.server.coordinator.DatasourceWhitelist;
import io.druid.server.coordinator.DruidCluster;
import io.druid.server.coordinator.DruidCoordinatorConfig;
import io.druid.server.coordinator.DruidCoordinatorRuntimeParams;
import io.druid.server.coordinator.LoadPeonCallback;
import io.druid.server.coordinator.LoadQueuePeon;
import io.druid.server.coordinator.LoadQueueTaskMaster;
import io.druid.server.coordinator.SegmentReplicantLookup;
import io.druid.server.coordinator.ServerHolder;
import io.druid.server.coordinator.helper.DruidCoordinatorBalancer;
import io.druid.server.coordinator.helper.DruidCoordinatorCleanupOvershadowed;
import io.druid.server.coordinator.helper.DruidCoordinatorCleanupUnneeded;
import io.druid.server.coordinator.helper.DruidCoordinatorHelper;
import io.druid.server.coordinator.helper.DruidCoordinatorLogger;
import io.druid.server.coordinator.helper.DruidCoordinatorRuleRunner;
import io.druid.server.coordinator.helper.DruidCoordinatorSegmentInfoLoader;
import io.druid.server.coordinator.helper.DruidCoordinatorSegmentMerger;
import io.druid.server.coordinator.rules.LoadRule;
import io.druid.server.coordinator.rules.Rule;
import io.druid.server.initialization.ZkPathsConfig;
import io.druid.timeline.DataSegment;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.recipes.leader.LeaderLatch;
import org.apache.curator.framework.recipes.leader.LeaderLatchListener;
import org.apache.curator.framework.recipes.leader.Participant;
import org.apache.curator.utils.ZKPaths;
import org.joda.time.DateTime;
import org.joda.time.Duration;

@ManageLifecycle
public class DruidCoordinator {
    public static final String COORDINATOR_OWNER_NODE = "_COORDINATOR";
    private static final EmittingLogger log = new EmittingLogger(DruidCoordinator.class);
    private final Object lock = new Object();
    private final DruidCoordinatorConfig config;
    private final ZkPathsConfig zkPaths;
    private final JacksonConfigManager configManager;
    private final DatabaseSegmentManager databaseSegmentManager;
    private final ServerInventoryView<Object> serverInventoryView;
    private final DatabaseRuleManager databaseRuleManager;
    private final CuratorFramework curator;
    private final ServiceEmitter emitter;
    private final IndexingServiceClient indexingServiceClient;
    private final ScheduledExecutorService exec;
    private final LoadQueueTaskMaster taskMaster;
    private final Map<String, LoadQueuePeon> loadManagementPeons;
    private final AtomicReference<LeaderLatch> leaderLatch;
    private final ServiceAnnouncer serviceAnnouncer;
    private final DruidNode self;
    private volatile boolean started = false;
    private volatile int leaderCounter = 0;
    private volatile boolean leader = false;
    private volatile SegmentReplicantLookup segmentReplicantLookup = null;

    @Inject
    public DruidCoordinator(DruidCoordinatorConfig config, ZkPathsConfig zkPaths, JacksonConfigManager configManager, DatabaseSegmentManager databaseSegmentManager, ServerInventoryView serverInventoryView, DatabaseRuleManager databaseRuleManager, CuratorFramework curator, ServiceEmitter emitter, ScheduledExecutorFactory scheduledExecutorFactory, IndexingServiceClient indexingServiceClient, LoadQueueTaskMaster taskMaster, ServiceAnnouncer serviceAnnouncer, @Self DruidNode self) {
        this(config, zkPaths, configManager, databaseSegmentManager, serverInventoryView, databaseRuleManager, curator, emitter, scheduledExecutorFactory, indexingServiceClient, taskMaster, serviceAnnouncer, self, Maps.newConcurrentMap());
    }

    DruidCoordinator(DruidCoordinatorConfig config, ZkPathsConfig zkPaths, JacksonConfigManager configManager, DatabaseSegmentManager databaseSegmentManager, ServerInventoryView serverInventoryView, DatabaseRuleManager databaseRuleManager, CuratorFramework curator, ServiceEmitter emitter, ScheduledExecutorFactory scheduledExecutorFactory, IndexingServiceClient indexingServiceClient, LoadQueueTaskMaster taskMaster, ServiceAnnouncer serviceAnnouncer, DruidNode self, ConcurrentMap<String, LoadQueuePeon> loadQueuePeonMap) {
        this.config = config;
        this.zkPaths = zkPaths;
        this.configManager = configManager;
        this.databaseSegmentManager = databaseSegmentManager;
        this.serverInventoryView = serverInventoryView;
        this.databaseRuleManager = databaseRuleManager;
        this.curator = curator;
        this.emitter = emitter;
        this.indexingServiceClient = indexingServiceClient;
        this.taskMaster = taskMaster;
        this.serviceAnnouncer = serviceAnnouncer;
        this.self = self;
        this.exec = scheduledExecutorFactory.create(1, "Coordinator-Exec--%d");
        this.leaderLatch = new AtomicReference<Object>(null);
        this.loadManagementPeons = loadQueuePeonMap;
    }

    public boolean isLeader() {
        return this.leader;
    }

    public Map<String, LoadQueuePeon> getLoadManagementPeons() {
        return this.loadManagementPeons;
    }

    public Map<String, CountingMap<String>> getReplicationStatus() {
        HashMap retVal = Maps.newHashMap();
        if (this.segmentReplicantLookup == null) {
            return retVal;
        }
        DateTime now = new DateTime();
        block0: for (DataSegment segment : this.getAvailableDataSegments()) {
            List<Rule> rules = this.databaseRuleManager.getRulesWithDefault(segment.getDataSource());
            for (Rule rule : rules) {
                if (!(rule instanceof LoadRule) || !rule.appliesTo(segment, now)) continue;
                for (Map.Entry<String, Integer> entry : ((LoadRule)rule).getTieredReplicants().entrySet()) {
                    CountingMap dataSourceMap = (CountingMap)retVal.get(entry.getKey());
                    if (dataSourceMap == null) {
                        dataSourceMap = new CountingMap();
                        retVal.put(entry.getKey(), dataSourceMap);
                    }
                    int diff = Math.max(entry.getValue() - this.segmentReplicantLookup.getTotalReplicants(segment.getIdentifier(), entry.getKey()), 0);
                    dataSourceMap.add((Object)segment.getDataSource(), (long)diff);
                }
                continue block0;
            }
        }
        return retVal;
    }

    public CountingMap<String> getSegmentAvailability() {
        CountingMap retVal = new CountingMap();
        if (this.segmentReplicantLookup == null) {
            return retVal;
        }
        for (DataSegment segment : this.getAvailableDataSegments()) {
            int available = this.segmentReplicantLookup.getTotalReplicants(segment.getIdentifier()) == 0 ? 0 : 1;
            retVal.add((Object)segment.getDataSource(), (long)(1 - available));
        }
        return retVal;
    }

    public Map<String, Double> getLoadStatus() {
        HashMap loadStatus = Maps.newHashMap();
        for (DruidDataSource dataSource : this.databaseSegmentManager.getInventory()) {
            HashSet segments = Sets.newHashSet(dataSource.getSegments());
            int availableSegmentSize = segments.size();
            for (DruidServer druidServer : this.serverInventoryView.getInventory()) {
                DruidDataSource loadedView = druidServer.getDataSource(dataSource.getName());
                if (loadedView == null) continue;
                segments.removeAll(loadedView.getSegments());
            }
            int unloadedSegmentSize = segments.size();
            loadStatus.put(dataSource.getName(), 100.0 * ((double)(availableSegmentSize - unloadedSegmentSize) / (double)availableSegmentSize));
        }
        return loadStatus;
    }

    public CoordinatorDynamicConfig getDynamicConfigs() {
        return (CoordinatorDynamicConfig)this.configManager.watch("coordinator.config", CoordinatorDynamicConfig.class, (Object)new CoordinatorDynamicConfig.Builder().build()).get();
    }

    public void removeSegment(DataSegment segment) {
        log.info("Removing Segment[%s]", new Object[]{segment});
        this.databaseSegmentManager.removeSegment(segment.getDataSource(), segment.getIdentifier());
    }

    public void removeDatasource(String ds) {
        this.databaseSegmentManager.removeDatasource(ds);
    }

    public void enableDatasource(String ds) {
        this.databaseSegmentManager.enableDatasource(ds);
    }

    public String getCurrentLeader() {
        try {
            LeaderLatch latch = this.leaderLatch.get();
            if (latch == null) {
                return null;
            }
            Participant participant = latch.getLeader();
            if (participant.isLeader()) {
                return participant.getId();
            }
            return null;
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public void moveSegment(ImmutableDruidServer fromServer, ImmutableDruidServer toServer, String segmentName, final LoadPeonCallback callback) {
        block7: {
            try {
                if (fromServer.getMetadata().equals(toServer.getMetadata())) {
                    throw new IAE("Cannot move [%s] to and from the same server [%s]", new Object[]{segmentName, fromServer.getName()});
                }
                final DataSegment segment = fromServer.getSegment(segmentName);
                if (segment == null) {
                    throw new IAE("Unable to find segment [%s] on server [%s]", new Object[]{segmentName, fromServer.getName()});
                }
                LoadQueuePeon loadPeon = this.loadManagementPeons.get(toServer.getName());
                if (loadPeon == null) {
                    throw new IAE("LoadQueuePeon hasn't been created yet for path [%s]", new Object[]{toServer.getName()});
                }
                final LoadQueuePeon dropPeon = this.loadManagementPeons.get(fromServer.getName());
                if (dropPeon == null) {
                    throw new IAE("LoadQueuePeon hasn't been created yet for path [%s]", new Object[]{fromServer.getName()});
                }
                ServerHolder toHolder = new ServerHolder(toServer, loadPeon);
                if (toHolder.getAvailableSize() < segment.getSize()) {
                    throw new IAE("Not enough capacity on server [%s] for segment [%s]. Required: %,d, available: %,d.", new Object[]{toServer.getName(), segment, segment.getSize(), toHolder.getAvailableSize()});
                }
                final String toLoadQueueSegPath = ZKPaths.makePath((String)ZKPaths.makePath((String)this.zkPaths.getLoadQueuePath(), (String)toServer.getName()), (String)segmentName);
                final String toServedSegPath = ZKPaths.makePath((String)ZKPaths.makePath((String)this.serverInventoryView.getInventoryManagerConfig().getInventoryPath(), (String)toServer.getName()), (String)segmentName);
                loadPeon.loadSegment(segment, new LoadPeonCallback(){

                    @Override
                    public void execute() {
                        try {
                            if (DruidCoordinator.this.curator.checkExists().forPath(toServedSegPath) != null && DruidCoordinator.this.curator.checkExists().forPath(toLoadQueueSegPath) == null && !dropPeon.getSegmentsToDrop().contains(segment)) {
                                dropPeon.dropSegment(segment, callback);
                            } else if (callback != null) {
                                callback.execute();
                            }
                        }
                        catch (Exception e) {
                            throw Throwables.propagate((Throwable)e);
                        }
                    }
                });
            }
            catch (Exception e) {
                log.makeAlert((Throwable)e, "Exception moving segment %s", new Object[]{segmentName}).emit();
                if (callback == null) break block7;
                callback.execute();
            }
        }
    }

    public Set<DataSegment> getOrderedAvailableDataSegments() {
        TreeSet availableSegments = Sets.newTreeSet((Comparator)Comparators.inverse((Comparator)DataSegment.bucketMonthComparator()));
        Iterable<DataSegment> dataSegments = this.getAvailableDataSegments();
        for (DataSegment dataSegment : dataSegments) {
            if (dataSegment.getSize() < 0L) {
                log.makeAlert("No size on Segment, wtf?", new Object[0]).addData("segment", (Object)dataSegment).emit();
            }
            availableSegments.add(dataSegment);
        }
        return availableSegments;
    }

    public Iterable<DataSegment> getAvailableDataSegments() {
        return Iterables.concat((Iterable)Iterables.transform(this.databaseSegmentManager.getInventory(), (Function)new Function<DruidDataSource, Iterable<DataSegment>>(){

            public Iterable<DataSegment> apply(DruidDataSource input) {
                return input.getSegments();
            }
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @LifecycleStart
    public void start() {
        Object object = this.lock;
        synchronized (object) {
            if (this.started) {
                return;
            }
            this.started = true;
            this.createNewLeaderLatch();
            try {
                this.leaderLatch.get().start();
            }
            catch (Exception e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
    }

    private LeaderLatch createNewLeaderLatch() {
        LeaderLatch newLeaderLatch = new LeaderLatch(this.curator, ZKPaths.makePath((String)this.zkPaths.getCoordinatorPath(), (String)COORDINATOR_OWNER_NODE), this.config.getHost());
        newLeaderLatch.addListener(new LeaderLatchListener(){

            public void isLeader() {
                DruidCoordinator.this.becomeLeader();
            }

            public void notLeader() {
                DruidCoordinator.this.stopBeingLeader();
            }
        }, (Executor)Execs.singleThreaded((String)"CoordinatorLeader-%s"));
        return this.leaderLatch.getAndSet(newLeaderLatch);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @LifecycleStop
    public void stop() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.started) {
                return;
            }
            this.stopBeingLeader();
            try {
                this.leaderLatch.get().close();
            }
            catch (IOException e) {
                log.warn((Throwable)e, "Unable to close leaderLatch, ignoring", new Object[0]);
            }
            this.started = false;
            this.exec.shutdownNow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void becomeLeader() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.started) {
                return;
            }
            log.info("I am the leader of the coordinators, all must bow!", new Object[0]);
            try {
                ++this.leaderCounter;
                this.leader = true;
                this.databaseSegmentManager.start();
                this.databaseRuleManager.start();
                this.serverInventoryView.start();
                this.serviceAnnouncer.announce(this.self);
                final int startingLeaderCounter = this.leaderCounter;
                ArrayList coordinatorRunnables = Lists.newArrayList();
                coordinatorRunnables.add(Pair.of((Object)new CoordinatorHistoricalManagerRunnable(startingLeaderCounter), (Object)this.config.getCoordinatorPeriod()));
                if (this.indexingServiceClient != null) {
                    coordinatorRunnables.add(Pair.of((Object)new CoordinatorIndexingServiceRunnable(this.makeIndexingServiceHelpers(this.configManager.watch("coordinator.whitelist", DatasourceWhitelist.class)), startingLeaderCounter), (Object)this.config.getCoordinatorIndexingPeriod()));
                }
                for (final Pair coordinatorRunnable : coordinatorRunnables) {
                    ScheduledExecutors.scheduleWithFixedDelay((ScheduledExecutorService)this.exec, (Duration)this.config.getCoordinatorStartDelay(), (Duration)((Duration)coordinatorRunnable.rhs), (Callable)new Callable<ScheduledExecutors.Signal>(){
                        private final CoordinatorRunnable theRunnable;
                        {
                            this.theRunnable = (CoordinatorRunnable)coordinatorRunnable.lhs;
                        }

                        @Override
                        public ScheduledExecutors.Signal call() {
                            if (DruidCoordinator.this.leader && startingLeaderCounter == DruidCoordinator.this.leaderCounter) {
                                this.theRunnable.run();
                            }
                            if (DruidCoordinator.this.leader && startingLeaderCounter == DruidCoordinator.this.leaderCounter) {
                                return ScheduledExecutors.Signal.REPEAT;
                            }
                            return ScheduledExecutors.Signal.STOP;
                        }
                    });
                }
            }
            catch (Exception e) {
                log.makeAlert((Throwable)e, "Unable to become leader", new Object[0]).emit();
                LeaderLatch oldLatch = this.createNewLeaderLatch();
                CloseQuietly.close((Closeable)oldLatch);
                try {
                    this.leaderLatch.get().start();
                }
                catch (Exception e1) {
                    log.makeAlert((Throwable)e1, "I am a zombie", new Object[0]).emit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopBeingLeader() {
        Object object = this.lock;
        synchronized (object) {
            try {
                ++this.leaderCounter;
                log.info("I am no longer the leader...", new Object[0]);
                for (String server : this.loadManagementPeons.keySet()) {
                    LoadQueuePeon peon = this.loadManagementPeons.remove(server);
                    peon.stop();
                }
                this.loadManagementPeons.clear();
                this.serviceAnnouncer.unannounce(this.self);
                this.serverInventoryView.stop();
                this.databaseRuleManager.stop();
                this.databaseSegmentManager.stop();
                this.leader = false;
            }
            catch (Exception e) {
                log.makeAlert((Throwable)e, "Unable to stopBeingLeader", new Object[0]).emit();
            }
        }
    }

    private List<DruidCoordinatorHelper> makeIndexingServiceHelpers(AtomicReference<DatasourceWhitelist> whitelistRef) {
        ArrayList helpers = Lists.newArrayList();
        helpers.add(new DruidCoordinatorSegmentInfoLoader(this));
        if (this.config.isConvertSegments()) {
            helpers.add(new DruidCoordinatorVersionConverter(this.indexingServiceClient, whitelistRef));
        }
        if (this.config.isMergeSegments()) {
            helpers.add(new DruidCoordinatorSegmentMerger(this.indexingServiceClient, whitelistRef));
            helpers.add(new DruidCoordinatorHelper(){

                @Override
                public DruidCoordinatorRuntimeParams run(DruidCoordinatorRuntimeParams params) {
                    CoordinatorStats stats = params.getCoordinatorStats();
                    log.info("Issued merge requests for %s segments", new Object[]{((AtomicLong)stats.getGlobalStats().get((Object)"mergedCount")).get()});
                    params.getEmitter().emit(new ServiceMetricEvent.Builder().build("coordinator/merge/count", (Number)stats.getGlobalStats().get((Object)"mergedCount")));
                    return params;
                }
            });
        }
        return ImmutableList.copyOf((Collection)helpers);
    }

    private class CoordinatorIndexingServiceRunnable
    extends CoordinatorRunnable {
        public CoordinatorIndexingServiceRunnable(List<DruidCoordinatorHelper> helpers, int startingLeaderCounter) {
            super(helpers, startingLeaderCounter);
        }
    }

    private class CoordinatorHistoricalManagerRunnable
    extends CoordinatorRunnable {
        public CoordinatorHistoricalManagerRunnable(int startingLeaderCounter) {
            super((List<DruidCoordinatorHelper>)ImmutableList.of((Object)new DruidCoordinatorSegmentInfoLoader(DruidCoordinator.this), (Object)new DruidCoordinatorHelper(){

                @Override
                public DruidCoordinatorRuntimeParams run(DruidCoordinatorRuntimeParams params) {
                    FunctionalIterable servers = FunctionalIterable.create(DruidCoordinator.this.serverInventoryView.getInventory()).filter((Predicate)new Predicate<DruidServer>(){

                        public boolean apply(DruidServer input) {
                            return input.isAssignable();
                        }
                    }).transform((Function)new Function<DruidServer, ImmutableDruidServer>(){

                        public ImmutableDruidServer apply(DruidServer input) {
                            return input.toImmutableDruidServer();
                        }
                    });
                    if (log.isDebugEnabled()) {
                        log.debug("Servers", new Object[0]);
                        for (ImmutableDruidServer druidServer : servers) {
                            log.debug("  %s", new Object[]{druidServer});
                            log.debug("    -- DataSources", new Object[0]);
                            for (ImmutableDruidDataSource druidDataSource : druidServer.getDataSources()) {
                                log.debug("    %s", new Object[]{druidDataSource});
                            }
                        }
                    }
                    DruidCluster cluster = new DruidCluster();
                    for (ImmutableDruidServer server : servers) {
                        if (!DruidCoordinator.this.loadManagementPeons.containsKey(server.getName())) {
                            String basePath = ZKPaths.makePath((String)DruidCoordinator.this.zkPaths.getLoadQueuePath(), (String)server.getName());
                            LoadQueuePeon loadQueuePeon = DruidCoordinator.this.taskMaster.giveMePeon(basePath);
                            log.info("Creating LoadQueuePeon for server[%s] at path[%s]", new Object[]{server.getName(), basePath});
                            DruidCoordinator.this.loadManagementPeons.put(server.getName(), loadQueuePeon);
                        }
                        cluster.add(new ServerHolder(server, (LoadQueuePeon)DruidCoordinator.this.loadManagementPeons.get(server.getName())));
                    }
                    DruidCoordinator.this.segmentReplicantLookup = SegmentReplicantLookup.make(cluster);
                    HashSet disappeared = Sets.newHashSet(DruidCoordinator.this.loadManagementPeons.keySet());
                    for (ImmutableDruidServer server : servers) {
                        disappeared.remove(server.getName());
                    }
                    for (String name : disappeared) {
                        log.info("Removing listener for server[%s] which is no longer there.", new Object[]{name});
                        LoadQueuePeon peon = (LoadQueuePeon)DruidCoordinator.this.loadManagementPeons.remove(name);
                        peon.stop();
                    }
                    return params.buildFromExisting().withDruidCluster(cluster).withDatabaseRuleManager(DruidCoordinator.this.databaseRuleManager).withLoadManagementPeons(DruidCoordinator.this.loadManagementPeons).withSegmentReplicantLookup(DruidCoordinator.this.segmentReplicantLookup).withBalancerReferenceTimestamp(DateTime.now()).build();
                }
            }, (Object)new DruidCoordinatorRuleRunner(DruidCoordinator.this), (Object)new DruidCoordinatorCleanupUnneeded(DruidCoordinator.this), (Object)new DruidCoordinatorCleanupOvershadowed(DruidCoordinator.this), (Object)new DruidCoordinatorBalancer(DruidCoordinator.this), (Object)new DruidCoordinatorLogger()), startingLeaderCounter);
        }
    }

    public abstract class CoordinatorRunnable
    implements Runnable {
        private final long startTime = System.currentTimeMillis();
        private final List<DruidCoordinatorHelper> helpers;
        private final int startingLeaderCounter;

        protected CoordinatorRunnable(List<DruidCoordinatorHelper> helpers, int startingLeaderCounter) {
            this.helpers = helpers;
            this.startingLeaderCounter = startingLeaderCounter;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                Object object = DruidCoordinator.this.lock;
                synchronized (object) {
                    LeaderLatch latch = (LeaderLatch)DruidCoordinator.this.leaderLatch.get();
                    if (latch == null || !latch.hasLeadership()) {
                        log.info("LEGGO MY EGGO. [%s] is leader.", new Object[]{latch == null ? null : latch.getLeader().getId()});
                        DruidCoordinator.this.stopBeingLeader();
                        return;
                    }
                }
                List<Boolean> allStarted = Arrays.asList(DruidCoordinator.this.databaseSegmentManager.isStarted(), DruidCoordinator.this.serverInventoryView.isStarted());
                for (Boolean aBoolean : allStarted) {
                    if (aBoolean.booleanValue()) continue;
                    log.error("InventoryManagers not started[%s]", new Object[]{allStarted});
                    DruidCoordinator.this.stopBeingLeader();
                    return;
                }
                CostBalancerStrategyFactory factory = new CostBalancerStrategyFactory(DruidCoordinator.this.getDynamicConfigs().getBalancerComputeThreads());
                DruidCoordinatorRuntimeParams params = DruidCoordinatorRuntimeParams.newBuilder().withStartTime(this.startTime).withDatasources(DruidCoordinator.this.databaseSegmentManager.getInventory()).withDynamicConfigs(DruidCoordinator.this.getDynamicConfigs()).withEmitter(DruidCoordinator.this.emitter).withBalancerStrategyFactory(factory).build();
                for (DruidCoordinatorHelper helper : this.helpers) {
                    if (!DruidCoordinator.this.leader || this.startingLeaderCounter != DruidCoordinator.this.leaderCounter) continue;
                    params = helper.run(params);
                }
            }
            catch (Exception e) {
                log.makeAlert((Throwable)e, "Caught exception, ignoring so that schedule keeps going.", new Object[0]).emit();
            }
        }
    }

    public static class DruidCoordinatorVersionConverter
    implements DruidCoordinatorHelper {
        private final IndexingServiceClient indexingServiceClient;
        private final AtomicReference<DatasourceWhitelist> whitelistRef;

        public DruidCoordinatorVersionConverter(IndexingServiceClient indexingServiceClient, AtomicReference<DatasourceWhitelist> whitelistRef) {
            this.indexingServiceClient = indexingServiceClient;
            this.whitelistRef = whitelistRef;
        }

        @Override
        public DruidCoordinatorRuntimeParams run(DruidCoordinatorRuntimeParams params) {
            DatasourceWhitelist whitelist = this.whitelistRef.get();
            for (DataSegment dataSegment : params.getAvailableSegments()) {
                Integer binaryVersion;
                if (whitelist != null && !whitelist.contains(dataSegment.getDataSource()) || (binaryVersion = dataSegment.getBinaryVersion()) != null && binaryVersion >= 9) continue;
                log.info("Upgrading version on segment[%s]", new Object[]{dataSegment.getIdentifier()});
                this.indexingServiceClient.upgradeSegment(dataSegment);
            }
            return params;
        }
    }
}

