/*
 * Decompiled with CFR 0.152.
 */
package io.druid.server.coordinator;

import com.google.api.client.util.Lists;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.metamx.common.Pair;
import com.metamx.emitter.EmittingLogger;
import io.druid.server.coordinator.BalancerSegmentHolder;
import io.druid.server.coordinator.BalancerStrategy;
import io.druid.server.coordinator.CoordinatorStats;
import io.druid.server.coordinator.ReservoirSegmentSampler;
import io.druid.server.coordinator.ServerHolder;
import io.druid.timeline.DataSegment;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.ReadableInterval;

public class CostBalancerStrategy
implements BalancerStrategy {
    private static final EmittingLogger log = new EmittingLogger(CostBalancerStrategy.class);
    private static final int DAY_IN_MILLIS = 86400000;
    private static final int SEVEN_DAYS_IN_MILLIS = 604800000;
    private static final int THIRTY_DAYS_IN_MILLIS = -1702967296;
    private final long referenceTimestamp;
    private final int threadCount;

    public CostBalancerStrategy(DateTime referenceTimestamp, int threadCount) {
        this.referenceTimestamp = referenceTimestamp.getMillis();
        this.threadCount = threadCount;
    }

    @Override
    public ServerHolder findNewSegmentHomeReplicator(DataSegment proposalSegment, List<ServerHolder> serverHolders) {
        ServerHolder holder = (ServerHolder)this.chooseBestServer((DataSegment)proposalSegment, serverHolders, (boolean)false).rhs;
        if (holder != null && !holder.isServingSegment(proposalSegment)) {
            return holder;
        }
        return null;
    }

    @Override
    public ServerHolder findNewSegmentHomeBalancer(DataSegment proposalSegment, List<ServerHolder> serverHolders) {
        return (ServerHolder)this.chooseBestServer((DataSegment)proposalSegment, serverHolders, (boolean)true).rhs;
    }

    public double computeJointSegmentCosts(DataSegment segment1, DataSegment segment2) {
        Interval gap = segment1.getInterval().gap((ReadableInterval)segment2.getInterval());
        double baseCost = Math.min(segment1.getSize(), segment2.getSize());
        double recencyPenalty = 1.0;
        double dataSourcePenalty = 1.0;
        double gapPenalty = 1.0;
        if (segment1.getDataSource().equals(segment2.getDataSource())) {
            dataSourcePenalty = 2.0;
        }
        double segment1diff = this.referenceTimestamp - segment1.getInterval().getEndMillis();
        double segment2diff = this.referenceTimestamp - segment2.getInterval().getEndMillis();
        if (segment1diff < 6.048E8 && segment2diff < 6.048E8) {
            recencyPenalty = (2.0 - segment1diff / 6.048E8) * (2.0 - segment2diff / 6.048E8);
        }
        if (gap == null) {
            gapPenalty = 2.0;
        } else {
            long gapMillis = gap.toDurationMillis();
            if (gapMillis < -1702967296L) {
                gapPenalty = 2L - gapMillis / -1702967296L;
            }
        }
        double cost = baseCost * recencyPenalty * dataSourcePenalty * gapPenalty;
        return cost;
    }

    @Override
    public BalancerSegmentHolder pickSegmentToMove(List<ServerHolder> serverHolders) {
        ReservoirSegmentSampler sampler = new ReservoirSegmentSampler();
        return sampler.getRandomBalancerSegmentHolder(serverHolders);
    }

    public double calculateInitialTotalCost(List<ServerHolder> serverHolders) {
        double cost = 0.0;
        for (ServerHolder server : serverHolders) {
            DataSegment[] segments = server.getServer().getSegments().values().toArray(new DataSegment[0]);
            for (int i = 0; i < segments.length; ++i) {
                for (int j = i; j < segments.length; ++j) {
                    cost += this.computeJointSegmentCosts(segments[i], segments[j]);
                }
            }
        }
        return cost;
    }

    public double calculateNormalization(List<ServerHolder> serverHolders) {
        double cost = 0.0;
        for (ServerHolder server : serverHolders) {
            for (DataSegment segment : server.getServer().getSegments().values()) {
                cost += this.computeJointSegmentCosts(segment, segment);
            }
        }
        return cost;
    }

    @Override
    public void emitStats(String tier, CoordinatorStats stats, List<ServerHolder> serverHolderList) {
        double initialTotalCost = this.calculateInitialTotalCost(serverHolderList);
        double normalization = this.calculateNormalization(serverHolderList);
        double normalizedInitialCost = initialTotalCost / normalization;
        stats.addToTieredStat("initialCost", tier, (long)initialTotalCost);
        stats.addToTieredStat("normalization", tier, (long)normalization);
        stats.addToTieredStat("normalizedInitialCostTimesOneThousand", tier, (long)(normalizedInitialCost * 1000.0));
        log.info("[%s]: Initial Total Cost: [%f], Normalization: [%f], Initial Normalized Cost: [%f]", new Object[]{tier, initialTotalCost, normalization, normalizedInitialCost});
    }

    protected double computeCost(DataSegment proposalSegment, ServerHolder server, boolean includeCurrentServer) {
        long proposalSegmentSize = proposalSegment.getSize();
        if (includeCurrentServer || !server.isServingSegment(proposalSegment)) {
            if (proposalSegmentSize > server.getAvailableSize() || server.isLoadingSegment(proposalSegment)) {
                return Double.POSITIVE_INFINITY;
            }
            double cost = 0.0;
            for (DataSegment segment : server.getServer().getSegments().values()) {
                if (proposalSegment.equals((Object)segment)) continue;
                cost += this.computeJointSegmentCosts(proposalSegment, segment);
            }
            for (DataSegment segment : server.getPeon().getSegmentsToLoad()) {
                cost += this.computeJointSegmentCosts(proposalSegment, segment);
            }
            return cost;
        }
        return Double.POSITIVE_INFINITY;
    }

    protected Pair<Double, ServerHolder> chooseBestServer(final DataSegment proposalSegment, Iterable<ServerHolder> serverHolders, final boolean includeCurrentServer) {
        Pair bestServer = Pair.of((Object)Double.POSITIVE_INFINITY, null);
        ListeningExecutorService service = MoreExecutors.listeningDecorator((ExecutorService)Executors.newFixedThreadPool(this.threadCount));
        ArrayList futures = Lists.newArrayList();
        for (final ServerHolder server : serverHolders) {
            futures.add(service.submit((Callable)new Callable<Pair<Double, ServerHolder>>(){

                @Override
                public Pair<Double, ServerHolder> call() throws Exception {
                    return Pair.of((Object)CostBalancerStrategy.this.computeCost(proposalSegment, server, includeCurrentServer), (Object)server);
                }
            }));
        }
        ListenableFuture resultsFuture = Futures.allAsList((Iterable)futures);
        try {
            for (Pair server : (List)resultsFuture.get()) {
                if (!((Double)server.lhs < (Double)bestServer.lhs)) continue;
                bestServer = server;
            }
        }
        catch (Exception e) {
            log.makeAlert((Throwable)e, "Cost Balancer Multithread strategy wasn't able to complete cost computation.", new Object[0]).emit();
        }
        service.shutdown();
        return bestServer;
    }
}

