/*
 * Decompiled with CFR 0.152.
 */
package io.druid.server.bridge;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Predicate;
import com.google.common.base.Throwables;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.inject.Inject;
import com.metamx.common.concurrent.ScheduledExecutorFactory;
import com.metamx.common.concurrent.ScheduledExecutors;
import com.metamx.common.guava.CloseQuietly;
import com.metamx.common.guava.FunctionalIterable;
import com.metamx.common.lifecycle.LifecycleStart;
import com.metamx.common.lifecycle.LifecycleStop;
import com.metamx.emitter.EmittingLogger;
import io.druid.client.DruidServer;
import io.druid.client.ServerInventoryView;
import io.druid.client.ServerView;
import io.druid.concurrent.Execs;
import io.druid.curator.announcement.Announcer;
import io.druid.guice.ManageLifecycle;
import io.druid.guice.annotations.Self;
import io.druid.server.DruidNode;
import io.druid.server.bridge.Bridge;
import io.druid.server.bridge.BridgeZkCoordinator;
import io.druid.server.bridge.DruidClusterBridgeConfig;
import io.druid.server.coordination.AbstractDataSegmentAnnouncer;
import io.druid.server.coordination.DataSegmentAnnouncer;
import io.druid.server.coordination.DruidServerMetadata;
import io.druid.timeline.DataSegment;
import java.io.Closeable;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.recipes.leader.LeaderLatch;
import org.apache.curator.framework.recipes.leader.LeaderLatchListener;
import org.apache.curator.utils.ZKPaths;
import org.joda.time.Duration;

@ManageLifecycle
public class DruidClusterBridge {
    public static final String BRIDGE_OWNER_NODE = "_BRIDGE";
    public static final String NODE_TYPE = "bridge";
    private static final EmittingLogger log = new EmittingLogger(DruidClusterBridge.class);
    private final ObjectMapper jsonMapper;
    private final DruidClusterBridgeConfig config;
    private final ScheduledExecutorService exec;
    private final DruidNode self;
    private final CuratorFramework curator;
    private final AtomicReference<LeaderLatch> leaderLatch;
    private final BridgeZkCoordinator bridgeZkCoordinator;
    private final Announcer announcer;
    private final ServerInventoryView<Object> serverInventoryView;
    private final Map<DataSegment, Integer> segments = Maps.newHashMap();
    private final Object lock = new Object();
    private volatile boolean started = false;
    private volatile boolean leader = false;

    @Inject
    public DruidClusterBridge(ObjectMapper jsonMapper, DruidClusterBridgeConfig config, ScheduledExecutorFactory scheduledExecutorFactory, @Self DruidNode self, CuratorFramework curator, AtomicReference<LeaderLatch> leaderLatch, BridgeZkCoordinator bridgeZkCoordinator, @Bridge Announcer announcer, final @Bridge AbstractDataSegmentAnnouncer dataSegmentAnnouncer, ServerInventoryView serverInventoryView) {
        this.jsonMapper = jsonMapper;
        this.config = config;
        this.bridgeZkCoordinator = bridgeZkCoordinator;
        this.announcer = announcer;
        this.serverInventoryView = serverInventoryView;
        this.curator = curator;
        this.leaderLatch = leaderLatch;
        this.exec = scheduledExecutorFactory.create(1, "Coordinator-Exec--%d");
        this.self = self;
        ExecutorService serverInventoryViewExec = Executors.newFixedThreadPool(1, new ThreadFactoryBuilder().setDaemon(true).setNameFormat("DruidClusterBridge-ServerInventoryView-%d").build());
        serverInventoryView.registerSegmentCallback(serverInventoryViewExec, new ServerView.BaseSegmentCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ServerView.CallbackAction segmentAdded(DruidServerMetadata server, DataSegment segment) {
                try {
                    Object object = DruidClusterBridge.this.lock;
                    synchronized (object) {
                        Integer count = (Integer)DruidClusterBridge.this.segments.get(segment);
                        if (count == null) {
                            DruidClusterBridge.this.segments.put(segment, 1);
                            dataSegmentAnnouncer.announceSegment(segment);
                        } else {
                            DruidClusterBridge.this.segments.put(segment, count + 1);
                        }
                    }
                }
                catch (Exception e) {
                    throw Throwables.propagate((Throwable)e);
                }
                return ServerView.CallbackAction.CONTINUE;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ServerView.CallbackAction segmentRemoved(DruidServerMetadata server, DataSegment segment) {
                try {
                    Object object = DruidClusterBridge.this.lock;
                    synchronized (object) {
                        DruidClusterBridge.this.serverRemovedSegment(dataSegmentAnnouncer, segment, server);
                    }
                }
                catch (Exception e) {
                    throw Throwables.propagate((Throwable)e);
                }
                return ServerView.CallbackAction.CONTINUE;
            }
        });
        serverInventoryView.registerServerCallback(serverInventoryViewExec, new ServerView.ServerCallback(){

            @Override
            public ServerView.CallbackAction serverRemoved(DruidServer server) {
                try {
                    for (DataSegment dataSegment : server.getSegments().values()) {
                        DruidClusterBridge.this.serverRemovedSegment(dataSegmentAnnouncer, dataSegment, server.getMetadata());
                    }
                }
                catch (Exception e) {
                    throw Throwables.propagate((Throwable)e);
                }
                return ServerView.CallbackAction.CONTINUE;
            }
        });
    }

    public boolean isLeader() {
        return this.leader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @LifecycleStart
    public void start() {
        Object object = this.lock;
        synchronized (object) {
            if (this.started) {
                return;
            }
            this.started = true;
            this.createNewLeaderLatch();
            try {
                this.leaderLatch.get().start();
            }
            catch (Exception e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
    }

    private LeaderLatch createNewLeaderLatch() {
        LeaderLatch newLeaderLatch = new LeaderLatch(this.curator, ZKPaths.makePath((String)this.config.getConnectorPath(), (String)BRIDGE_OWNER_NODE), this.self.getHost());
        newLeaderLatch.addListener(new LeaderLatchListener(){

            public void isLeader() {
                DruidClusterBridge.this.becomeLeader();
            }

            public void notLeader() {
                DruidClusterBridge.this.stopBeingLeader();
            }
        }, (Executor)Execs.singleThreaded((String)"CoordinatorLeader-%s"));
        return this.leaderLatch.getAndSet(newLeaderLatch);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @LifecycleStop
    public void stop() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.started) {
                return;
            }
            this.stopBeingLeader();
            try {
                this.leaderLatch.get().close();
            }
            catch (IOException e) {
                log.warn((Throwable)e, "Unable to close leaderLatch, ignoring", new Object[0]);
            }
            this.exec.shutdown();
            this.started = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void becomeLeader() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.started) {
                return;
            }
            log.info("Go-Go Gadgetmobile! Starting bridge in %s", new Object[]{this.config.getStartDelay()});
            try {
                this.bridgeZkCoordinator.start();
                this.serverInventoryView.start();
                ScheduledExecutors.scheduleWithFixedDelay((ScheduledExecutorService)this.exec, (Duration)this.config.getStartDelay(), (Duration)this.config.getPeriod(), (Callable)new Callable<ScheduledExecutors.Signal>(){

                    @Override
                    public ScheduledExecutors.Signal call() {
                        if (DruidClusterBridge.this.leader) {
                            FunctionalIterable servers = FunctionalIterable.create(DruidClusterBridge.this.serverInventoryView.getInventory()).filter((Predicate)new Predicate<DruidServer>(){

                                public boolean apply(DruidServer input) {
                                    return input.isAssignable();
                                }
                            });
                            long totalMaxSize = 0L;
                            for (DruidServer server : servers) {
                                totalMaxSize += server.getMaxSize();
                            }
                            if (totalMaxSize == 0L) {
                                log.warn("No servers founds!", new Object[0]);
                            } else {
                                DruidServerMetadata me = new DruidServerMetadata(DruidClusterBridge.this.self.getHost(), DruidClusterBridge.this.self.getHost(), totalMaxSize, DruidClusterBridge.NODE_TYPE, DruidClusterBridge.this.config.getTier(), DruidClusterBridge.this.config.getPriority());
                                try {
                                    String path = ZKPaths.makePath((String)DruidClusterBridge.this.config.getAnnouncementsPath(), (String)DruidClusterBridge.this.self.getHost());
                                    log.info("Updating [%s] to have a maxSize of[%,d] bytes", new Object[]{DruidClusterBridge.this.self.getHost(), totalMaxSize});
                                    DruidClusterBridge.this.announcer.update(path, DruidClusterBridge.this.jsonMapper.writeValueAsBytes((Object)me));
                                }
                                catch (Exception e) {
                                    throw Throwables.propagate((Throwable)e);
                                }
                            }
                        }
                        if (DruidClusterBridge.this.leader) {
                            return ScheduledExecutors.Signal.REPEAT;
                        }
                        return ScheduledExecutors.Signal.STOP;
                    }
                });
                this.leader = true;
            }
            catch (Exception e) {
                log.makeAlert((Throwable)e, "Exception becoming leader", new Object[0]).emit();
                LeaderLatch oldLatch = this.createNewLeaderLatch();
                CloseQuietly.close((Closeable)oldLatch);
                try {
                    this.leaderLatch.get().start();
                }
                catch (Exception e1) {
                    log.makeAlert((Throwable)e1, "I am a zombie", new Object[0]).emit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopBeingLeader() {
        Object object = this.lock;
        synchronized (object) {
            try {
                log.info("I'll get you next time, Gadget. Next time!", new Object[0]);
                this.bridgeZkCoordinator.stop();
                this.serverInventoryView.stop();
                this.leader = false;
            }
            catch (Exception e) {
                log.makeAlert((Throwable)e, "Unable to stopBeingLeader", new Object[0]).emit();
            }
        }
    }

    private void serverRemovedSegment(DataSegmentAnnouncer dataSegmentAnnouncer, DataSegment segment, DruidServerMetadata server) throws IOException {
        Integer count = this.segments.get(segment);
        if (count != null) {
            if (count == 1) {
                dataSegmentAnnouncer.unannounceSegment(segment);
                this.segments.remove(segment);
            } else {
                this.segments.put(segment, count - 1);
            }
        } else {
            log.makeAlert("Trying to remove a segment that was never added?", new Object[0]).addData("server", (Object)server.getHost()).addData("segmentId", (Object)segment.getIdentifier()).emit();
        }
    }
}

