/*
 * Decompiled with CFR 0.152.
 */
package io.druid.server.bridge;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Charsets;
import com.google.inject.Inject;
import com.metamx.common.guava.Sequence;
import com.metamx.common.guava.Sequences;
import com.metamx.common.logger.Logger;
import com.metamx.http.client.HttpClient;
import com.metamx.http.client.response.HttpResponseHandler;
import com.metamx.http.client.response.StatusResponseHandler;
import com.metamx.http.client.response.StatusResponseHolder;
import io.druid.client.selector.Server;
import io.druid.curator.discovery.ServerDiscoverySelector;
import io.druid.guice.annotations.Global;
import io.druid.query.Query;
import io.druid.query.QueryRunner;
import io.druid.query.QuerySegmentWalker;
import io.druid.query.SegmentDescriptor;
import java.net.URL;
import java.util.List;
import org.joda.time.Interval;

public class BridgeQuerySegmentWalker
implements QuerySegmentWalker {
    private static final Logger log = new Logger(BridgeQuerySegmentWalker.class);
    private final ServerDiscoverySelector brokerSelector;
    private final HttpClient httpClient;
    private final ObjectMapper jsonMapper;
    private final StatusResponseHandler responseHandler;

    @Inject
    public BridgeQuerySegmentWalker(ServerDiscoverySelector brokerSelector, @Global HttpClient httpClient, ObjectMapper jsonMapper) {
        this.brokerSelector = brokerSelector;
        this.httpClient = httpClient;
        this.jsonMapper = jsonMapper;
        this.responseHandler = new StatusResponseHandler(Charsets.UTF_8);
    }

    public <T> QueryRunner<T> getQueryRunnerForIntervals(Query<T> query, Iterable<Interval> intervals) {
        return this.makeRunner();
    }

    public <T> QueryRunner<T> getQueryRunnerForSegments(Query<T> query, Iterable<SegmentDescriptor> specs) {
        return this.makeRunner();
    }

    private <T> QueryRunner<T> makeRunner() {
        return new QueryRunner<T>(){

            public Sequence<T> run(Query<T> query) {
                try {
                    Server instance = BridgeQuerySegmentWalker.this.brokerSelector.pick();
                    if (instance == null) {
                        return Sequences.empty();
                    }
                    String url = String.format("http://%s/druid/v2/", BridgeQuerySegmentWalker.this.brokerSelector.pick().getHost());
                    StatusResponseHolder response = (StatusResponseHolder)BridgeQuerySegmentWalker.this.httpClient.post(new URL(url)).setContent("application/json", BridgeQuerySegmentWalker.this.jsonMapper.writeValueAsBytes(query)).go((HttpResponseHandler)BridgeQuerySegmentWalker.this.responseHandler).get();
                    List results = (List)BridgeQuerySegmentWalker.this.jsonMapper.readValue(response.getContent(), new TypeReference<List<T>>(){});
                    return Sequences.simple((Iterable)results);
                }
                catch (Exception e) {
                    log.error((Throwable)e, "Exception with bridge query", new Object[0]);
                    return Sequences.empty();
                }
            }
        };
    }
}

