/*
 * Decompiled with CFR 0.152.
 */
package io.druid.server;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.druid.initialization.DruidModule;
import io.druid.initialization.Initialization;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;

@Path(value="/{a:status|health}")
public class StatusResource {
    @GET
    @Produces(value={"application/json"})
    public Status doGet() {
        return new Status(Initialization.getLoadedModules(DruidModule.class));
    }

    public static class Memory {
        final long maxMemory;
        final long totalMemory;
        final long freeMemory;
        final long usedMemory;

        public Memory(Runtime runtime) {
            this.maxMemory = runtime.maxMemory();
            this.totalMemory = runtime.totalMemory();
            this.freeMemory = runtime.freeMemory();
            this.usedMemory = this.totalMemory - this.freeMemory;
        }

        @JsonProperty
        public long getMaxMemory() {
            return this.maxMemory;
        }

        @JsonProperty
        public long getTotalMemory() {
            return this.totalMemory;
        }

        @JsonProperty
        public long getFreeMemory() {
            return this.freeMemory;
        }

        @JsonProperty
        public long getUsedMemory() {
            return this.usedMemory;
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public static class ModuleVersion {
        final String name;
        final String artifact;
        final String version;

        public ModuleVersion(String name, String artifact, String version) {
            this.name = name;
            this.artifact = artifact;
            this.version = version;
        }

        @JsonProperty
        public String getName() {
            return this.name;
        }

        @JsonProperty
        public String getArtifact() {
            return this.artifact;
        }

        @JsonProperty
        public String getVersion() {
            return this.version;
        }

        public String toString() {
            if (this.artifact == null || this.artifact.isEmpty()) {
                return String.format("  - %s ", this.name);
            }
            return String.format("  - %s (%s-%s)", this.name, this.artifact, this.version);
        }
    }

    public static class Status {
        final String version = this.getDruidVersion();
        final List<ModuleVersion> modules;
        final Memory memory;

        public Status(Collection<DruidModule> modules) {
            this.modules = this.getExtensionVersions(modules);
            this.memory = new Memory(Runtime.getRuntime());
        }

        private String getDruidVersion() {
            return Status.class.getPackage().getImplementationVersion();
        }

        @JsonProperty
        public String getVersion() {
            return this.version;
        }

        @JsonProperty
        public List<ModuleVersion> getModules() {
            return this.modules;
        }

        @JsonProperty
        public Memory getMemory() {
            return this.memory;
        }

        public String toString() {
            String NL = System.getProperty("line.separator");
            StringBuilder output = new StringBuilder();
            output.append(String.format("Druid version - %s", this.version)).append(NL).append(NL);
            if (this.modules.size() > 0) {
                output.append("Registered Druid Modules").append(NL);
            } else {
                output.append("No Druid Modules loaded !");
            }
            for (ModuleVersion moduleVersion : this.modules) {
                output.append(moduleVersion).append(NL);
            }
            return output.toString();
        }

        private List<ModuleVersion> getExtensionVersions(Collection<DruidModule> druidModules) {
            ArrayList<ModuleVersion> moduleVersions = new ArrayList<ModuleVersion>();
            for (DruidModule module : druidModules) {
                String artifact = module.getClass().getPackage().getImplementationTitle();
                String version = module.getClass().getPackage().getImplementationVersion();
                moduleVersions.add(new ModuleVersion(module.getClass().getCanonicalName(), artifact, version));
            }
            return moduleVersions;
        }
    }
}

