/*
 * Decompiled with CFR 0.152.
 */
package io.druid.server;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.ByteStreams;
import com.google.inject.Inject;
import com.metamx.common.guava.Sequence;
import com.metamx.common.guava.Sequences;
import com.metamx.common.guava.Yielder;
import com.metamx.common.guava.YieldingAccumulator;
import com.metamx.emitter.EmittingLogger;
import com.metamx.emitter.service.ServiceEmitter;
import com.metamx.emitter.service.ServiceMetricEvent;
import io.druid.guice.annotations.Json;
import io.druid.guice.annotations.Smile;
import io.druid.query.DataSource;
import io.druid.query.DataSourceUtil;
import io.druid.query.Query;
import io.druid.query.QueryInterruptedException;
import io.druid.query.QuerySegmentWalker;
import io.druid.server.QueryManager;
import io.druid.server.QueryStats;
import io.druid.server.RequestLogLine;
import io.druid.server.initialization.ServerConfig;
import io.druid.server.log.RequestLogger;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.UUID;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.DELETE;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import org.joda.time.DateTime;

@Path(value="/druid/v2/")
public class QueryResource {
    private static final EmittingLogger log = new EmittingLogger(QueryResource.class);
    private static final Joiner COMMA_JOIN = Joiner.on((String)",");
    public static final String APPLICATION_SMILE = "application/smile";
    public static final String APPLICATION_JSON = "application/json";
    private final ServerConfig config;
    private final ObjectMapper jsonMapper;
    private final ObjectMapper smileMapper;
    private final QuerySegmentWalker texasRanger;
    private final ServiceEmitter emitter;
    private final RequestLogger requestLogger;
    private final QueryManager queryManager;

    @Inject
    public QueryResource(ServerConfig config, @Json ObjectMapper jsonMapper, @Smile ObjectMapper smileMapper, QuerySegmentWalker texasRanger, ServiceEmitter emitter, RequestLogger requestLogger, QueryManager queryManager) {
        this.config = config;
        this.jsonMapper = jsonMapper.copy();
        this.jsonMapper.getFactory().configure(JsonGenerator.Feature.AUTO_CLOSE_TARGET, false);
        this.smileMapper = smileMapper.copy();
        this.smileMapper.getFactory().configure(JsonGenerator.Feature.AUTO_CLOSE_TARGET, false);
        this.texasRanger = texasRanger;
        this.emitter = emitter;
        this.requestLogger = requestLogger;
        this.queryManager = queryManager;
    }

    @DELETE
    @Path(value="{id}")
    @Produces(value={"application/json"})
    public Response getServer(@PathParam(value="id") String queryId) {
        this.queryManager.cancelQuery(queryId);
        return Response.status((Response.Status)Response.Status.ACCEPTED).build();
    }

    @POST
    public Response doPost(@Context HttpServletRequest req, @Context HttpServletResponse resp) throws ServletException, IOException {
        Sequence res;
        long start = System.currentTimeMillis();
        Object query = null;
        byte[] requestQuery = null;
        String queryId = null;
        boolean isSmile = APPLICATION_SMILE.equals(req.getContentType());
        ObjectMapper objectMapper = isSmile ? this.smileMapper : this.jsonMapper;
        final ObjectWriter jsonWriter = req.getParameter("pretty") == null ? objectMapper.writer() : objectMapper.writerWithDefaultPrettyPrinter();
        requestQuery = ByteStreams.toByteArray((InputStream)req.getInputStream());
        query = (Query)objectMapper.readValue(requestQuery, Query.class);
        queryId = query.getId();
        if (queryId == null) {
            queryId = UUID.randomUUID().toString();
            query = query.withId(queryId);
        }
        if (query.getContextValue("timeout") == null) {
            query = query.withOverriddenContext((Map)ImmutableMap.of((Object)"timeout", (Object)this.config.getMaxIdleTime().toStandardDuration().getMillis()));
        }
        if (log.isDebugEnabled()) {
            log.debug("Got query [%s]", new Object[]{query});
        }
        Sequence results = (res = query.run(this.texasRanger)) == null ? Sequences.empty() : res;
        final Yielder yielder = results.toYielder(null, new YieldingAccumulator(){

            public Object accumulate(Object accumulated, Object in) {
                this.yield();
                return in;
            }
        });
        try {
            long requestTime = System.currentTimeMillis() - start;
            this.emitter.emit(new ServiceMetricEvent.Builder().setUser2(DataSourceUtil.getMetricName((DataSource)query.getDataSource())).setUser3(this.jsonMapper.writeValueAsString(query.getContext() == null ? ImmutableMap.of() : query.getContext())).setUser4(query.getType()).setUser5(COMMA_JOIN.join((Iterable)query.getIntervals())).setUser6(String.valueOf(query.hasFilters())).setUser7(req.getRemoteAddr()).setUser8(queryId).setUser9(query.getDuration().toPeriod().toStandardMinutes().toString()).build("request/time", (Number)requestTime));
            this.requestLogger.log(new RequestLogLine(new DateTime(), req.getRemoteAddr(), (Query)query, new QueryStats((Map<String, Object>)ImmutableMap.of((Object)"request/time", (Object)requestTime, (Object)"success", (Object)true))));
            Response response = Response.ok((Object)new StreamingOutput(){

                public void write(OutputStream outputStream) throws IOException, WebApplicationException {
                    jsonWriter.writeValue(outputStream, (Object)yielder);
                    outputStream.close();
                }
            }, (String)(isSmile ? APPLICATION_JSON : APPLICATION_SMILE)).header("X-Druid-Query-Id", (Object)queryId).build();
            return response;
        }
        catch (Exception e) {
            try {
                yielder.close();
                throw Throwables.propagate((Throwable)e);
            }
            catch (QueryInterruptedException e2) {
                try {
                    log.info("%s [%s]", new Object[]{e2.getMessage(), queryId});
                    this.requestLogger.log(new RequestLogLine(new DateTime(), req.getRemoteAddr(), (Query)query, new QueryStats((Map<String, Object>)ImmutableMap.of((Object)"success", (Object)false, (Object)"interrupted", (Object)true, (Object)"reason", (Object)e2.toString()))));
                }
                catch (Exception e22) {
                    log.error((Throwable)e22, "Unable to log query [%s]!", new Object[]{query});
                }
                return Response.serverError().entity((Object)jsonWriter.writeValueAsString((Object)ImmutableMap.of((Object)"error", (Object)e2.getMessage()))).build();
            }
            catch (Exception e3) {
                String queryString = query == null ? (isSmile ? "smile_unknown" : new String(requestQuery, Charsets.UTF_8)) : query.toString();
                log.warn((Throwable)e3, "Exception occurred on request [%s]", new Object[]{queryString});
                try {
                    this.requestLogger.log(new RequestLogLine(new DateTime(), req.getRemoteAddr(), (Query)query, new QueryStats((Map<String, Object>)ImmutableMap.of((Object)"success", (Object)false, (Object)"exception", (Object)e3.toString()))));
                }
                catch (Exception e2) {
                    log.error((Throwable)e2, "Unable to log query [%s]!", new Object[]{queryString});
                }
                log.makeAlert((Throwable)e3, "Exception handling request", new Object[0]).addData("exception", (Object)e3.toString()).addData("query", (Object)queryString).addData("peer", (Object)req.getRemoteAddr()).emit();
                return Response.serverError().entity((Object)jsonWriter.writeValueAsString((Object)ImmutableMap.of((Object)"error", (Object)(e3.getMessage() == null ? "null exception" : e3.getMessage())))).build();
            }
        }
    }
}

