/*
 * Decompiled with CFR 0.152.
 */
package io.druid.server;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import io.druid.query.Query;
import io.druid.query.QueryWatcher;
import java.util.Set;
import java.util.concurrent.Executor;

public class QueryManager
implements QueryWatcher {
    final SetMultimap<String, ListenableFuture> queries = Multimaps.synchronizedSetMultimap((SetMultimap)HashMultimap.create());

    public boolean cancelQuery(String id) {
        Set futures = this.queries.removeAll((Object)id);
        boolean success = true;
        for (ListenableFuture future : futures) {
            success = success && future.cancel(true);
        }
        return success;
    }

    public void registerQuery(Query query, final ListenableFuture future) {
        final String id = query.getId();
        this.queries.put((Object)id, (Object)future);
        future.addListener(new Runnable(){

            @Override
            public void run() {
                QueryManager.this.queries.remove((Object)id, (Object)future);
            }
        }, (Executor)MoreExecutors.sameThreadExecutor());
    }
}

