/*
 * Decompiled with CFR 0.152.
 */
package io.druid.server;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableMap;
import com.metamx.emitter.EmittingLogger;
import com.metamx.emitter.service.ServiceEmitter;
import com.metamx.emitter.service.ServiceMetricEvent;
import io.druid.guice.annotations.Json;
import io.druid.guice.annotations.Smile;
import io.druid.query.DataSource;
import io.druid.query.DataSourceUtil;
import io.druid.query.Query;
import io.druid.server.QueryStats;
import io.druid.server.RequestLogLine;
import io.druid.server.log.RequestLogger;
import io.druid.server.router.QueryHostFinder;
import io.druid.server.router.Router;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.Enumeration;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import javax.servlet.AsyncContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.api.ContentProvider;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.client.api.Response;
import org.eclipse.jetty.client.api.Result;
import org.eclipse.jetty.client.util.BytesContentProvider;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.proxy.AsyncProxyServlet;
import org.eclipse.jetty.proxy.ProxyServlet;
import org.joda.time.DateTime;

public class AsyncQueryForwardingServlet
extends AsyncProxyServlet {
    private static final EmittingLogger log = new EmittingLogger(AsyncQueryForwardingServlet.class);
    private final ObjectMapper jsonMapper;
    private final ObjectMapper smileMapper;
    private final QueryHostFinder hostFinder;
    private final HttpClient httpClient;
    private final ServiceEmitter emitter;
    private final RequestLogger requestLogger;

    private static void handleException(HttpServletResponse response, ObjectMapper objectMapper, Exception exception) throws IOException {
        if (!response.isCommitted()) {
            String errorMessage = exception.getMessage() == null ? "null exception" : exception.getMessage();
            response.resetBuffer();
            response.setStatus(500);
            objectMapper.writeValue((OutputStream)response.getOutputStream(), (Object)ImmutableMap.of((Object)"error", (Object)errorMessage));
        }
        response.flushBuffer();
    }

    public AsyncQueryForwardingServlet(@Json ObjectMapper jsonMapper, @Smile ObjectMapper smileMapper, QueryHostFinder hostFinder, @Router HttpClient httpClient, ServiceEmitter emitter, RequestLogger requestLogger) {
        this.jsonMapper = jsonMapper;
        this.smileMapper = smileMapper;
        this.hostFinder = hostFinder;
        this.httpClient = httpClient;
        this.emitter = emitter;
        this.requestLogger = requestLogger;
    }

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        URI rewrittenURI;
        boolean isSmile = "application/smile".equals(request.getContentType());
        ObjectMapper objectMapper = isSmile ? this.smileMapper : this.jsonMapper;
        String host = this.hostFinder.getDefaultHost();
        Query inputQuery = null;
        boolean hasContent = request.getContentLength() > 0 || request.getContentType() != null;
        boolean isQuery = request.getMethod().equals(HttpMethod.POST.asString());
        long startTime = System.currentTimeMillis();
        if (isQuery) {
            try {
                inputQuery = (Query)objectMapper.readValue((InputStream)request.getInputStream(), Query.class);
                if (inputQuery != null) {
                    host = this.hostFinder.getHost(inputQuery);
                    if (inputQuery.getId() == null) {
                        inputQuery = inputQuery.withId(UUID.randomUUID().toString());
                    }
                }
            }
            catch (IOException e) {
                log.warn((Throwable)e, "Exception parsing query", new Object[0]);
                String errorMessage = e.getMessage() == null ? "no error message" : e.getMessage();
                this.requestLogger.log(new RequestLogLine(new DateTime(), request.getRemoteAddr(), null, new QueryStats((Map<String, Object>)ImmutableMap.of((Object)"success", (Object)false, (Object)"exception", (Object)errorMessage))));
                response.setStatus(400);
                response.setContentType("application/json");
                objectMapper.writeValue((OutputStream)response.getOutputStream(), (Object)ImmutableMap.of((Object)"error", (Object)errorMessage));
                return;
            }
            catch (Exception e) {
                AsyncQueryForwardingServlet.handleException(response, objectMapper, e);
                return;
            }
        }
        if ((rewrittenURI = this.rewriteURI(host, request)) == null) {
            this.onRewriteFailed(request, response);
            return;
        }
        Request proxyRequest = this.getHttpClient().newRequest(rewrittenURI).method(request.getMethod()).version(HttpVersion.fromString((String)request.getProtocol()));
        Enumeration headerNames = request.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String headerName = (String)headerNames.nextElement();
            if (HttpHeader.TRANSFER_ENCODING.is(headerName)) {
                hasContent = true;
            }
            Enumeration headerValues = request.getHeaders(headerName);
            while (headerValues.hasMoreElements()) {
                String headerValue = (String)headerValues.nextElement();
                if (headerValue == null) continue;
                proxyRequest.header(headerName, headerValue);
            }
        }
        this.addViaHeader(proxyRequest);
        this.addXForwardedHeaders(proxyRequest, request);
        AsyncContext asyncContext = request.startAsync();
        asyncContext.setTimeout(0L);
        proxyRequest.timeout(this.getTimeout(), TimeUnit.MILLISECONDS);
        if (hasContent) {
            if (inputQuery != null) {
                proxyRequest.content((ContentProvider)new BytesContentProvider((byte[][])new byte[][]{this.jsonMapper.writeValueAsBytes((Object)inputQuery)}));
            } else {
                proxyRequest.content(this.proxyRequestContent(proxyRequest, request));
            }
        }
        this.customizeProxyRequest(proxyRequest, request);
        if (isQuery) {
            proxyRequest.send((Response.CompleteListener)this.newMetricsEmittingProxyResponseListener(request, response, inputQuery, startTime));
        } else {
            proxyRequest.send((Response.CompleteListener)this.newProxyResponseListener(request, response));
        }
    }

    protected HttpClient createHttpClient() throws ServletException {
        return this.httpClient;
    }

    private URI rewriteURI(String host, HttpServletRequest req) {
        StringBuilder uri = new StringBuilder("http://");
        uri.append(host);
        uri.append(req.getRequestURI());
        String queryString = req.getQueryString();
        if (queryString != null) {
            uri.append("?").append(queryString);
        }
        return URI.create(uri.toString());
    }

    private Response.Listener newMetricsEmittingProxyResponseListener(HttpServletRequest request, HttpServletResponse response, Query query, long start) {
        return new MetricsEmittingProxyResponseListener(request, response, query, start);
    }

    private class MetricsEmittingProxyResponseListener
    extends ProxyServlet.ProxyResponseListener {
        private final HttpServletRequest req;
        private final HttpServletResponse res;
        private final Query query;
        private final long start;

        public MetricsEmittingProxyResponseListener(HttpServletRequest request, HttpServletResponse response, Query query, long start) {
            super((ProxyServlet)AsyncQueryForwardingServlet.this, request, response);
            this.req = request;
            this.res = response;
            this.query = query;
            this.start = start;
        }

        public void onComplete(Result result) {
            long requestTime = System.currentTimeMillis() - this.start;
            try {
                AsyncQueryForwardingServlet.this.emitter.emit(new ServiceMetricEvent.Builder().setUser2(DataSourceUtil.getMetricName((DataSource)this.query.getDataSource())).setUser3(AsyncQueryForwardingServlet.this.jsonMapper.writeValueAsString(this.query.getContext() == null ? ImmutableMap.of() : this.query.getContext())).setUser4(this.query.getType()).setUser5(DataSourceUtil.COMMA_JOIN.join((Iterable)this.query.getIntervals())).setUser6(String.valueOf(this.query.hasFilters())).setUser7(this.req.getRemoteAddr()).setUser8(this.query.getId()).setUser9(this.query.getDuration().toPeriod().toStandardMinutes().toString()).build("request/time", (Number)requestTime));
                AsyncQueryForwardingServlet.this.requestLogger.log(new RequestLogLine(new DateTime(), this.req.getRemoteAddr(), this.query, new QueryStats((Map<String, Object>)ImmutableMap.of((Object)"request/time", (Object)requestTime, (Object)"success", (Object)true))));
            }
            catch (Exception e) {
                log.error((Throwable)e, "Unable to log query [%s]!", new Object[]{this.query});
            }
            super.onComplete(result);
        }

        public void onFailure(Response response, Throwable failure) {
            try {
                String errorMessage = failure.getMessage();
                AsyncQueryForwardingServlet.this.requestLogger.log(new RequestLogLine(new DateTime(), this.req.getRemoteAddr(), this.query, new QueryStats((Map<String, Object>)ImmutableMap.of((Object)"success", (Object)false, (Object)"exception", (Object)(errorMessage == null ? "no message" : errorMessage)))));
            }
            catch (IOException logError) {
                log.error((Throwable)logError, "Unable to log query [%s]!", new Object[]{this.query});
            }
            log.makeAlert(failure, "Exception handling request", new Object[0]).addData("exception", (Object)failure.toString()).addData("query", (Object)this.query).addData("peer", (Object)this.req.getRemoteAddr()).emit();
            super.onFailure(response, failure);
        }
    }
}

