/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.realtime.plumber;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.metamx.common.Granularity;
import com.metamx.emitter.service.ServiceEmitter;
import io.druid.client.FilteredServerView;
import io.druid.guice.annotations.Processing;
import io.druid.query.QueryRunnerFactoryConglomerate;
import io.druid.segment.indexing.DataSchema;
import io.druid.segment.indexing.RealtimeTuningConfig;
import io.druid.segment.loading.DataSegmentPusher;
import io.druid.segment.realtime.FireDepartmentMetrics;
import io.druid.segment.realtime.SegmentPublisher;
import io.druid.segment.realtime.plumber.Plumber;
import io.druid.segment.realtime.plumber.PlumberSchool;
import io.druid.segment.realtime.plumber.RealtimePlumber;
import io.druid.segment.realtime.plumber.RejectionPolicyFactory;
import io.druid.segment.realtime.plumber.VersioningPolicy;
import io.druid.server.coordination.DataSegmentAnnouncer;
import java.io.File;
import java.util.concurrent.ExecutorService;
import org.joda.time.Period;

public class RealtimePlumberSchool
implements PlumberSchool {
    private final ServiceEmitter emitter;
    private final QueryRunnerFactoryConglomerate conglomerate;
    private final DataSegmentPusher dataSegmentPusher;
    private final DataSegmentAnnouncer segmentAnnouncer;
    private final SegmentPublisher segmentPublisher;
    private final FilteredServerView serverView;
    private final ExecutorService queryExecutorService;
    private final Period windowPeriod;
    private final File basePersistDirectory;
    private final Granularity segmentGranularity;
    private final VersioningPolicy versioningPolicy;
    private final RejectionPolicyFactory rejectionPolicyFactory;
    private final int maxPendingPersists;

    @JsonCreator
    public RealtimePlumberSchool(@JacksonInject ServiceEmitter emitter, @JacksonInject QueryRunnerFactoryConglomerate conglomerate, @JacksonInject DataSegmentPusher dataSegmentPusher, @JacksonInject DataSegmentAnnouncer segmentAnnouncer, @JacksonInject SegmentPublisher segmentPublisher, @JacksonInject FilteredServerView serverView, @JacksonInject @Processing ExecutorService executorService, @JsonProperty(value="windowPeriod") Period windowPeriod, @JsonProperty(value="basePersistDirectory") File basePersistDirectory, @JsonProperty(value="segmentGranularity") Granularity segmentGranularity, @JsonProperty(value="versioningPolicy") VersioningPolicy versioningPolicy, @JsonProperty(value="rejectionPolicy") RejectionPolicyFactory rejectionPolicy, @JsonProperty(value="rejectionPolicyFactory") RejectionPolicyFactory rejectionPolicyFactory, @JsonProperty(value="maxPendingPersists") int maxPendingPersists) {
        this.emitter = emitter;
        this.conglomerate = conglomerate;
        this.dataSegmentPusher = dataSegmentPusher;
        this.segmentAnnouncer = segmentAnnouncer;
        this.segmentPublisher = segmentPublisher;
        this.serverView = serverView;
        this.queryExecutorService = executorService;
        this.windowPeriod = windowPeriod;
        this.basePersistDirectory = basePersistDirectory;
        this.segmentGranularity = segmentGranularity;
        this.versioningPolicy = versioningPolicy;
        this.rejectionPolicyFactory = rejectionPolicy == null ? rejectionPolicyFactory : rejectionPolicy;
        this.maxPendingPersists = maxPendingPersists;
    }

    @Deprecated
    public Period getWindowPeriod() {
        return this.windowPeriod;
    }

    @Deprecated
    public File getBasePersistDirectory() {
        return this.basePersistDirectory;
    }

    @Override
    @JsonProperty
    public Granularity getSegmentGranularity() {
        return this.segmentGranularity;
    }

    @Deprecated
    public VersioningPolicy getVersioningPolicy() {
        return this.versioningPolicy;
    }

    @Deprecated
    public RejectionPolicyFactory getRejectionPolicyFactory() {
        return this.rejectionPolicyFactory;
    }

    @Deprecated
    public int getMaxPendingPersists() {
        return this.maxPendingPersists;
    }

    @Override
    public Plumber findPlumber(DataSchema schema, RealtimeTuningConfig config, FireDepartmentMetrics metrics) {
        this.verifyState();
        return new RealtimePlumber(schema, config, metrics, this.emitter, this.conglomerate, this.segmentAnnouncer, this.queryExecutorService, this.dataSegmentPusher, this.segmentPublisher, this.serverView);
    }

    private void verifyState() {
        Preconditions.checkNotNull((Object)this.conglomerate, (Object)"must specify a queryRunnerFactoryConglomerate to do this action.");
        Preconditions.checkNotNull((Object)this.dataSegmentPusher, (Object)"must specify a segmentPusher to do this action.");
        Preconditions.checkNotNull((Object)this.segmentAnnouncer, (Object)"must specify a segmentAnnouncer to do this action.");
        Preconditions.checkNotNull((Object)this.segmentPublisher, (Object)"must specify a segmentPublisher to do this action.");
        Preconditions.checkNotNull((Object)this.serverView, (Object)"must specify a serverView to do this action.");
        Preconditions.checkNotNull((Object)this.emitter, (Object)"must specify a serviceEmitter to do this action.");
    }
}

