/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.realtime.plumber;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.metamx.common.Granularity;
import com.metamx.emitter.service.ServiceEmitter;
import io.druid.guice.annotations.Processing;
import io.druid.query.QueryRunnerFactoryConglomerate;
import io.druid.segment.indexing.DataSchema;
import io.druid.segment.indexing.RealtimeTuningConfig;
import io.druid.segment.realtime.FireDepartmentMetrics;
import io.druid.segment.realtime.plumber.FlushingPlumber;
import io.druid.segment.realtime.plumber.Plumber;
import io.druid.segment.realtime.plumber.RealtimePlumberSchool;
import io.druid.segment.realtime.plumber.RejectionPolicyFactory;
import io.druid.segment.realtime.plumber.VersioningPolicy;
import io.druid.server.coordination.DataSegmentAnnouncer;
import java.io.File;
import java.util.concurrent.ExecutorService;
import org.joda.time.Duration;
import org.joda.time.Period;

public class FlushingPlumberSchool
extends RealtimePlumberSchool {
    private static final Duration defaultFlushDuration = new Duration((Object)"PT1H");
    private final Duration flushDuration;
    private final ServiceEmitter emitter;
    private final QueryRunnerFactoryConglomerate conglomerate;
    private final DataSegmentAnnouncer segmentAnnouncer;
    private final ExecutorService queryExecutorService;

    @JsonCreator
    public FlushingPlumberSchool(@JsonProperty(value="flushDuration") Duration flushDuration, @JacksonInject ServiceEmitter emitter, @JacksonInject QueryRunnerFactoryConglomerate conglomerate, @JacksonInject DataSegmentAnnouncer segmentAnnouncer, @JacksonInject @Processing ExecutorService queryExecutorService, @JsonProperty(value="windowPeriod") Period windowPeriod, @JsonProperty(value="basePersistDirectory") File basePersistDirectory, @JsonProperty(value="segmentGranularity") Granularity segmentGranularity, @JsonProperty(value="versioningPolicy") VersioningPolicy versioningPolicy, @JsonProperty(value="rejectionPolicy") RejectionPolicyFactory rejectionPolicy, @JsonProperty(value="rejectionPolicyFactory") RejectionPolicyFactory rejectionPolicyFactory, @JsonProperty(value="maxPendingPersists") int maxPendingPersists) {
        super(emitter, conglomerate, null, segmentAnnouncer, null, null, queryExecutorService, windowPeriod, basePersistDirectory, segmentGranularity, versioningPolicy, rejectionPolicy, rejectionPolicyFactory, maxPendingPersists);
        this.flushDuration = flushDuration == null ? defaultFlushDuration : flushDuration;
        this.emitter = emitter;
        this.conglomerate = conglomerate;
        this.segmentAnnouncer = segmentAnnouncer;
        this.queryExecutorService = queryExecutorService;
    }

    @Override
    public Plumber findPlumber(DataSchema schema, RealtimeTuningConfig config, FireDepartmentMetrics metrics) {
        this.verifyState();
        return new FlushingPlumber(this.flushDuration, schema, config, metrics, this.emitter, this.conglomerate, this.segmentAnnouncer, this.queryExecutorService);
    }

    private void verifyState() {
        Preconditions.checkNotNull((Object)this.conglomerate, (Object)"must specify a queryRunnerFactoryConglomerate to do this action.");
        Preconditions.checkNotNull((Object)this.segmentAnnouncer, (Object)"must specify a segmentAnnouncer to do this action.");
        Preconditions.checkNotNull((Object)this.emitter, (Object)"must specify a serviceEmitter to do this action.");
    }
}

