/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.realtime.plumber;

import com.google.common.collect.Lists;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.metamx.common.Granularity;
import com.metamx.common.concurrent.ScheduledExecutors;
import com.metamx.emitter.EmittingLogger;
import com.metamx.emitter.service.ServiceEmitter;
import io.druid.common.guava.ThreadRenamingCallable;
import io.druid.query.QueryRunnerFactoryConglomerate;
import io.druid.segment.indexing.DataSchema;
import io.druid.segment.indexing.RealtimeTuningConfig;
import io.druid.segment.realtime.FireDepartmentMetrics;
import io.druid.segment.realtime.plumber.RealtimePlumber;
import io.druid.segment.realtime.plumber.Sink;
import io.druid.server.coordination.DataSegmentAnnouncer;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.joda.time.ReadableDuration;
import org.joda.time.ReadableInstant;

public class FlushingPlumber
extends RealtimePlumber {
    private static final EmittingLogger log = new EmittingLogger(FlushingPlumber.class);
    private final DataSchema schema;
    private final RealtimeTuningConfig config;
    private final Duration flushDuration;
    private volatile ScheduledExecutorService flushScheduledExec = null;
    private volatile boolean stopped = false;

    public FlushingPlumber(Duration flushDuration, DataSchema schema, RealtimeTuningConfig config, FireDepartmentMetrics metrics, ServiceEmitter emitter, QueryRunnerFactoryConglomerate conglomerate, DataSegmentAnnouncer segmentAnnouncer, ExecutorService queryExecutorService) {
        super(schema, config, metrics, emitter, conglomerate, segmentAnnouncer, queryExecutorService, null, null, null);
        this.flushDuration = flushDuration;
        this.schema = schema;
        this.config = config;
    }

    @Override
    public void startJob() {
        log.info("Starting job for %s", new Object[]{this.getSchema().getDataSource()});
        this.computeBaseDir(this.getSchema()).mkdirs();
        this.initializeExecutors();
        if (this.flushScheduledExec == null) {
            this.flushScheduledExec = Executors.newScheduledThreadPool(1, new ThreadFactoryBuilder().setDaemon(true).setNameFormat("flushing_scheduled_%d").build());
        }
        this.bootstrapSinksFromDisk();
        this.startFlushThread();
    }

    protected void flushAfterDuration(final long truncatedTime, final Sink sink) {
        log.info("Abandoning segment %s at %s", new Object[]{sink.getSegment().getIdentifier(), new DateTime().plusMillis((int)this.flushDuration.getMillis())});
        ScheduledExecutors.scheduleWithFixedDelay((ScheduledExecutorService)this.flushScheduledExec, (Duration)this.flushDuration, (Callable)new Callable<ScheduledExecutors.Signal>(){

            @Override
            public ScheduledExecutors.Signal call() throws Exception {
                log.info("Abandoning segment %s", new Object[]{sink.getSegment().getIdentifier()});
                FlushingPlumber.this.abandonSegment(truncatedTime, sink);
                return ScheduledExecutors.Signal.STOP;
            }
        });
    }

    private void startFlushThread() {
        final Granularity segmentGranularity = this.schema.getGranularitySpec().getSegmentGranularity();
        DateTime truncatedNow = segmentGranularity.truncate(new DateTime());
        final long windowMillis = this.config.getWindowPeriod().toStandardDuration().getMillis();
        log.info("Expect to run at [%s]", new Object[]{new DateTime().plus((ReadableDuration)new Duration(System.currentTimeMillis(), this.schema.getGranularitySpec().getSegmentGranularity().increment(truncatedNow).getMillis() + windowMillis))});
        ScheduledExecutors.scheduleAtFixedRate((ScheduledExecutorService)this.flushScheduledExec, (Duration)new Duration(System.currentTimeMillis(), this.schema.getGranularitySpec().getSegmentGranularity().increment(truncatedNow).getMillis() + windowMillis), (Duration)new Duration((ReadableInstant)truncatedNow, (ReadableInstant)segmentGranularity.increment(truncatedNow)), (Callable)new ThreadRenamingCallable<ScheduledExecutors.Signal>(String.format("%s-flusher-%d", this.getSchema().getDataSource(), this.getConfig().getShardSpec().getPartitionNum())){

            public ScheduledExecutors.Signal doCall() {
                if (FlushingPlumber.this.stopped) {
                    log.info("Stopping flusher thread", new Object[0]);
                    return ScheduledExecutors.Signal.STOP;
                }
                long minTimestamp = segmentGranularity.truncate(FlushingPlumber.this.getRejectionPolicy().getCurrMaxTime().minus(windowMillis)).getMillis();
                ArrayList sinksToPush = Lists.newArrayList();
                for (Map.Entry<Long, Sink> entry : FlushingPlumber.this.getSinks().entrySet()) {
                    Long intervalStart = entry.getKey();
                    if (intervalStart >= minTimestamp) continue;
                    log.info("Adding entry[%s] to flush.", new Object[]{entry});
                    sinksToPush.add(entry);
                }
                for (Map.Entry<Long, Sink> entry : sinksToPush) {
                    FlushingPlumber.this.flushAfterDuration(entry.getKey(), entry.getValue());
                }
                if (FlushingPlumber.this.stopped) {
                    log.info("Stopping flusher thread", new Object[0]);
                    return ScheduledExecutors.Signal.STOP;
                }
                return ScheduledExecutors.Signal.REPEAT;
            }
        });
    }

    @Override
    public void finishJob() {
        log.info("Stopping job", new Object[0]);
        for (Map.Entry<Long, Sink> entry : this.getSinks().entrySet()) {
            this.abandonSegment(entry.getKey(), entry.getValue());
        }
        this.shutdownExecutors();
        if (this.flushScheduledExec != null) {
            this.flushScheduledExec.shutdown();
        }
        this.stopped = true;
    }
}

