/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.realtime.firehose;

import com.google.common.base.Optional;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import com.metamx.common.ISE;
import com.metamx.common.logger.Logger;
import io.druid.curator.discovery.ServiceAnnouncer;
import io.druid.guice.annotations.Self;
import io.druid.segment.realtime.firehose.ChatHandler;
import io.druid.segment.realtime.firehose.ChatHandlerProvider;
import io.druid.server.DruidNode;
import java.util.concurrent.ConcurrentMap;

public class ServiceAnnouncingChatHandlerProvider
implements ChatHandlerProvider {
    private static final Logger log = new Logger(ServiceAnnouncingChatHandlerProvider.class);
    private final DruidNode node;
    private final ServiceAnnouncer serviceAnnouncer;
    private final ConcurrentMap<String, ChatHandler> handlers;

    @Inject
    public ServiceAnnouncingChatHandlerProvider(@Self DruidNode node, ServiceAnnouncer serviceAnnouncer) {
        this.node = node;
        this.serviceAnnouncer = serviceAnnouncer;
        this.handlers = Maps.newConcurrentMap();
    }

    @Override
    public void register(String service, ChatHandler handler) {
        DruidNode node = this.makeDruidNode(service);
        log.info("Registering Eventhandler[%s]", new Object[]{service});
        if (this.handlers.putIfAbsent(service, handler) != null) {
            throw new ISE("handler already registered for service[%s]", new Object[]{service});
        }
        try {
            this.serviceAnnouncer.announce(node);
        }
        catch (Exception e) {
            log.warn((Throwable)e, "Failed to register service[%s]", new Object[]{service});
            this.handlers.remove(service, handler);
        }
    }

    @Override
    public void unregister(String service) {
        log.info("Unregistering chat handler[%s]", new Object[]{service});
        ChatHandler handler = (ChatHandler)this.handlers.get(service);
        if (handler == null) {
            log.warn("handler[%s] not currently registered, ignoring.", new Object[]{service});
        }
        try {
            this.serviceAnnouncer.unannounce(this.makeDruidNode(service));
        }
        catch (Exception e) {
            log.warn((Throwable)e, "Failed to unregister service[%s]", new Object[]{service});
        }
        this.handlers.remove(service, handler);
    }

    @Override
    public Optional<ChatHandler> get(String key) {
        return Optional.fromNullable(this.handlers.get(key));
    }

    private DruidNode makeDruidNode(String key) {
        return new DruidNode(key, this.node.getHost(), this.node.getPort());
    }
}

