/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.realtime.firehose;

import com.google.common.base.Predicate;
import io.druid.data.input.Firehose;
import io.druid.data.input.InputRow;
import java.io.IOException;

public class PredicateFirehose
implements Firehose {
    private final Firehose firehose;
    private final Predicate<InputRow> predicate;
    private InputRow savedInputRow = null;

    public PredicateFirehose(Firehose firehose, Predicate<InputRow> predicate) {
        this.firehose = firehose;
        this.predicate = predicate;
    }

    public boolean hasMore() {
        if (this.savedInputRow != null) {
            return true;
        }
        while (this.firehose.hasMore()) {
            InputRow row = this.firehose.nextRow();
            if (!this.predicate.apply((Object)row)) continue;
            this.savedInputRow = row;
            return true;
        }
        return false;
    }

    public InputRow nextRow() {
        InputRow row = this.savedInputRow;
        this.savedInputRow = null;
        return row;
    }

    public Runnable commit() {
        return this.firehose.commit();
    }

    public void close() throws IOException {
        this.firehose.close();
    }
}

