/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.realtime.firehose;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.api.client.repackaged.com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import com.metamx.common.ISE;
import io.druid.data.input.Firehose;
import io.druid.data.input.FirehoseFactory;
import io.druid.data.input.impl.FileIteratingFirehose;
import io.druid.data.input.impl.StringInputRowParser;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.LineIterator;

public class LocalFirehoseFactory
implements FirehoseFactory<StringInputRowParser> {
    private final File baseDir;
    private final String filter;
    private final StringInputRowParser parser;

    @JsonCreator
    public LocalFirehoseFactory(@JsonProperty(value="baseDir") File baseDir, @JsonProperty(value="filter") String filter, @JsonProperty(value="parser") StringInputRowParser parser) {
        this.baseDir = baseDir;
        this.filter = filter;
        this.parser = parser;
    }

    @JsonProperty
    public File getBaseDir() {
        return this.baseDir;
    }

    @JsonProperty
    public String getFilter() {
        return this.filter;
    }

    @JsonProperty
    public StringInputRowParser getParser() {
        return this.parser;
    }

    public Firehose connect(StringInputRowParser firehoseParser) throws IOException {
        File[] foundFiles = this.baseDir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File file, String name) {
                return name.contains(LocalFirehoseFactory.this.filter);
            }
        });
        if (foundFiles == null || foundFiles.length == 0) {
            throw new ISE("Found no files to ingest! Check your schema.", new Object[0]);
        }
        final LinkedList files = Lists.newLinkedList(Arrays.asList(foundFiles));
        return new FileIteratingFirehose((Iterator)new Iterator<LineIterator>(){

            @Override
            public boolean hasNext() {
                return !files.isEmpty();
            }

            @Override
            public LineIterator next() {
                try {
                    return FileUtils.lineIterator((File)((File)files.poll()));
                }
                catch (Exception e) {
                    throw Throwables.propagate((Throwable)e);
                }
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        }, firehoseParser);
    }
}

