/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.realtime.firehose;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.api.client.repackaged.com.google.common.base.Preconditions;
import com.google.api.client.repackaged.com.google.common.base.Throwables;
import com.metamx.emitter.EmittingLogger;
import io.druid.data.input.Firehose;
import io.druid.data.input.FirehoseFactory;
import io.druid.data.input.InputRow;
import io.druid.data.input.impl.InputRowParser;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;

public class CombiningFirehoseFactory
implements FirehoseFactory<InputRowParser> {
    private static final EmittingLogger log = new EmittingLogger(CombiningFirehoseFactory.class);
    private final List<FirehoseFactory> delegateFactoryList;

    @JsonCreator
    public CombiningFirehoseFactory(@JsonProperty(value="delegates") List<FirehoseFactory> delegateFactoryList) {
        Preconditions.checkArgument((!delegateFactoryList.isEmpty() ? 1 : 0) != 0);
        this.delegateFactoryList = delegateFactoryList;
    }

    public Firehose connect(InputRowParser parser) throws IOException {
        return new CombiningFirehose(parser);
    }

    public InputRowParser getParser() {
        return this.delegateFactoryList.get(0).getParser();
    }

    @JsonProperty(value="delegates")
    public List<FirehoseFactory> getDelegateFactoryList() {
        return this.delegateFactoryList;
    }

    public class CombiningFirehose
    implements Firehose {
        private final InputRowParser parser;
        private final Iterator<FirehoseFactory> firehoseFactoryIterator;
        private volatile Firehose currentFirehose;

        public CombiningFirehose(InputRowParser parser) throws IOException {
            this.firehoseFactoryIterator = CombiningFirehoseFactory.this.delegateFactoryList.iterator();
            this.parser = parser;
            this.nextFirehose();
        }

        private void nextFirehose() {
            if (this.firehoseFactoryIterator.hasNext()) {
                try {
                    if (this.currentFirehose != null) {
                        this.currentFirehose.close();
                    }
                    this.currentFirehose = this.firehoseFactoryIterator.next().connect(this.parser);
                }
                catch (IOException e) {
                    if (this.currentFirehose != null) {
                        try {
                            this.currentFirehose.close();
                        }
                        catch (IOException e2) {
                            log.error((Throwable)e, "Unable to close currentFirehose!", new Object[0]);
                            throw Throwables.propagate((Throwable)e2);
                        }
                    }
                    throw Throwables.propagate((Throwable)e);
                }
            }
        }

        public boolean hasMore() {
            return this.currentFirehose.hasMore();
        }

        public InputRow nextRow() {
            InputRow rv = this.currentFirehose.nextRow();
            if (!this.currentFirehose.hasMore()) {
                this.nextFirehose();
            }
            return rv;
        }

        public Runnable commit() {
            return this.currentFirehose.commit();
        }

        public void close() throws IOException {
            this.currentFirehose.close();
        }
    }
}

