/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.realtime;

import io.druid.segment.IncrementalIndexSegment;
import io.druid.segment.Segment;
import io.druid.segment.incremental.IncrementalIndex;

public class FireHydrant {
    private volatile IncrementalIndex index;
    private volatile Segment adapter;
    private final int count;

    public FireHydrant(IncrementalIndex index, int count, String segmentIdentifier) {
        this.index = index;
        this.adapter = new IncrementalIndexSegment(index, segmentIdentifier);
        this.count = count;
    }

    public FireHydrant(Segment adapter, int count) {
        this.index = null;
        this.adapter = adapter;
        this.count = count;
    }

    public IncrementalIndex getIndex() {
        return this.index;
    }

    public Segment getSegment() {
        return this.adapter;
    }

    public int getCount() {
        return this.count;
    }

    public boolean hasSwapped() {
        return this.index == null;
    }

    public void swapSegment(Segment adapter) {
        this.adapter = adapter;
        this.index = null;
    }

    public String toString() {
        return "FireHydrant{index=" + this.index + ", queryable=" + this.adapter + ", count=" + this.count + '}';
    }
}

