/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.realtime;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.api.client.util.Lists;
import com.google.common.base.Preconditions;
import io.druid.data.input.Firehose;
import io.druid.data.input.FirehoseFactory;
import io.druid.segment.indexing.DataSchema;
import io.druid.segment.indexing.IngestionSpec;
import io.druid.segment.indexing.RealtimeIOConfig;
import io.druid.segment.indexing.RealtimeTuningConfig;
import io.druid.segment.indexing.granularity.UniformGranularitySpec;
import io.druid.segment.realtime.FireDepartmentConfig;
import io.druid.segment.realtime.FireDepartmentMetrics;
import io.druid.segment.realtime.Schema;
import io.druid.segment.realtime.plumber.Plumber;
import io.druid.segment.realtime.plumber.PlumberSchool;
import io.druid.segment.realtime.plumber.RealtimePlumberSchool;
import java.io.IOException;

public class FireDepartment
extends IngestionSpec<RealtimeIOConfig, RealtimeTuningConfig> {
    private final DataSchema dataSchema;
    private final RealtimeIOConfig ioConfig;
    private final RealtimeTuningConfig tuningConfig;
    private final FireDepartmentMetrics metrics = new FireDepartmentMetrics();

    @JsonCreator
    public FireDepartment(@JsonProperty(value="dataSchema") DataSchema dataSchema, @JsonProperty(value="ioConfig") RealtimeIOConfig ioConfig, @JsonProperty(value="tuningConfig") RealtimeTuningConfig tuningConfig, @JsonProperty(value="schema") Schema schema, @JsonProperty(value="config") FireDepartmentConfig config, @JsonProperty(value="firehose") FirehoseFactory firehoseFactory, @JsonProperty(value="plumber") PlumberSchool plumberSchool) {
        super(dataSchema, ioConfig, tuningConfig);
        if (dataSchema == null) {
            Preconditions.checkNotNull((Object)schema, (Object)"schema");
            Preconditions.checkNotNull((Object)config, (Object)"config");
            Preconditions.checkNotNull((Object)firehoseFactory, (Object)"firehoseFactory");
            Preconditions.checkNotNull((Object)plumberSchool, (Object)"plumberSchool");
            this.dataSchema = new DataSchema(schema.getDataSource(), firehoseFactory.getParser(), schema.getAggregators(), new UniformGranularitySpec(plumberSchool.getSegmentGranularity(), schema.getIndexGranularity(), Lists.newArrayList(), plumberSchool.getSegmentGranularity()));
            this.ioConfig = new RealtimeIOConfig(firehoseFactory, plumberSchool);
            this.tuningConfig = new RealtimeTuningConfig(config.getMaxRowsInMemory(), config.getIntermediatePersistPeriod(), ((RealtimePlumberSchool)plumberSchool).getWindowPeriod(), ((RealtimePlumberSchool)plumberSchool).getBasePersistDirectory(), ((RealtimePlumberSchool)plumberSchool).getVersioningPolicy(), ((RealtimePlumberSchool)plumberSchool).getRejectionPolicyFactory(), ((RealtimePlumberSchool)plumberSchool).getMaxPendingPersists(), schema.getShardSpec());
        } else {
            Preconditions.checkNotNull((Object)dataSchema, (Object)"dataSchema");
            Preconditions.checkNotNull((Object)ioConfig, (Object)"ioConfig");
            this.dataSchema = dataSchema;
            this.ioConfig = ioConfig;
            this.tuningConfig = tuningConfig == null ? RealtimeTuningConfig.makeDefaultTuningConfig() : tuningConfig;
        }
    }

    @Override
    @JsonProperty(value="dataSchema")
    public DataSchema getDataSchema() {
        return this.dataSchema;
    }

    @Override
    @JsonProperty(value="ioConfig")
    public RealtimeIOConfig getIOConfig() {
        return this.ioConfig;
    }

    @Override
    @JsonProperty(value="tuningConfig")
    public RealtimeTuningConfig getTuningConfig() {
        return this.tuningConfig;
    }

    public Plumber findPlumber() {
        return this.ioConfig.getPlumberSchool().findPlumber(this.dataSchema, this.tuningConfig, this.metrics);
    }

    public Firehose connect() throws IOException {
        return this.ioConfig.getFirehoseFactory().connect(this.dataSchema.getParser());
    }

    public FireDepartmentMetrics getMetrics() {
        return this.metrics;
    }
}

