/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.loading;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.metamx.common.ISE;
import com.metamx.common.MapUtils;
import com.metamx.common.logger.Logger;
import io.druid.segment.QueryableIndex;
import io.druid.segment.QueryableIndexSegment;
import io.druid.segment.Segment;
import io.druid.segment.loading.DataSegmentPuller;
import io.druid.segment.loading.DataSegmentPusherUtil;
import io.druid.segment.loading.QueryableIndexFactory;
import io.druid.segment.loading.SegmentLoader;
import io.druid.segment.loading.SegmentLoaderConfig;
import io.druid.segment.loading.SegmentLoadingException;
import io.druid.segment.loading.StorageLocation;
import io.druid.segment.loading.StorageLocationConfig;
import io.druid.timeline.DataSegment;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;

public class OmniSegmentLoader
implements SegmentLoader {
    private static final Logger log = new Logger(OmniSegmentLoader.class);
    private final Map<String, DataSegmentPuller> pullers;
    private final QueryableIndexFactory factory;
    private final SegmentLoaderConfig config;
    private final List<StorageLocation> locations;

    @Inject
    public OmniSegmentLoader(Map<String, DataSegmentPuller> pullers, QueryableIndexFactory factory, SegmentLoaderConfig config) {
        this.pullers = pullers;
        this.factory = factory;
        this.config = config;
        this.locations = Lists.newArrayList();
        for (StorageLocationConfig locationConfig : config.getLocations()) {
            this.locations.add(new StorageLocation(locationConfig.getPath(), locationConfig.getMaxSize()));
        }
    }

    public OmniSegmentLoader withConfig(SegmentLoaderConfig config) {
        return new OmniSegmentLoader(this.pullers, this.factory, config);
    }

    @Override
    public boolean isSegmentLoaded(DataSegment segment) {
        return this.findStorageLocationIfLoaded(segment) != null;
    }

    public StorageLocation findStorageLocationIfLoaded(DataSegment segment) {
        for (StorageLocation location : this.locations) {
            File localStorageDir = new File(location.getPath(), DataSegmentPusherUtil.getStorageDir((DataSegment)segment));
            if (!localStorageDir.exists()) continue;
            return location;
        }
        return null;
    }

    @Override
    public Segment getSegment(DataSegment segment) throws SegmentLoadingException {
        File segmentFiles = this.getSegmentFiles(segment);
        QueryableIndex index = this.factory.factorize(segmentFiles);
        return new QueryableIndexSegment(segment.getIdentifier(), index);
    }

    @Override
    public File getSegmentFiles(DataSegment segment) throws SegmentLoadingException {
        File retVal;
        StorageLocation loc = this.findStorageLocationIfLoaded(segment);
        if (loc == null) {
            Iterator<StorageLocation> locIter = this.locations.iterator();
            loc = locIter.next();
            while (locIter.hasNext()) {
                loc = loc.mostEmpty(locIter.next());
            }
            if (!loc.canHandle(segment.getSize())) {
                throw new ISE("Segment[%s:%,d] too large for storage[%s:%,d].", new Object[]{segment.getIdentifier(), segment.getSize(), loc.getPath(), loc.available()});
            }
            File storageDir = new File(loc.getPath(), DataSegmentPusherUtil.getStorageDir((DataSegment)segment));
            if (!storageDir.mkdirs()) {
                log.debug("Unable to make parent file[%s]", new Object[]{storageDir});
            }
            this.getPuller(segment.getLoadSpec()).getSegmentFiles(segment, storageDir);
            loc.addSegment(segment);
            retVal = storageDir;
        } else {
            retVal = new File(loc.getPath(), DataSegmentPusherUtil.getStorageDir((DataSegment)segment));
        }
        loc.addSegment(segment);
        return retVal;
    }

    @Override
    public void cleanup(DataSegment segment) throws SegmentLoadingException {
        if (!this.config.isDeleteOnRemove()) {
            return;
        }
        StorageLocation loc = this.findStorageLocationIfLoaded(segment);
        if (loc == null) {
            log.info("Asked to cleanup something[%s] that didn't exist.  Skipping.", new Object[]{segment});
            return;
        }
        try {
            File cacheFile = new File(loc.getPath(), DataSegmentPusherUtil.getStorageDir((DataSegment)segment));
            log.info("Deleting directory[%s]", new Object[]{cacheFile});
            FileUtils.deleteDirectory((File)cacheFile);
            loc.removeSegment(segment);
        }
        catch (IOException e) {
            throw new SegmentLoadingException((Throwable)e, e.getMessage(), new Object[0]);
        }
    }

    private DataSegmentPuller getPuller(Map<String, Object> loadSpec) throws SegmentLoadingException {
        String type = MapUtils.getString(loadSpec, (String)"type");
        DataSegmentPuller loader = this.pullers.get(type);
        if (loader == null) {
            throw new SegmentLoadingException("Unknown loader type[%s].  Known types are %s", new Object[]{type, this.pullers.keySet()});
        }
        return loader;
    }
}

