/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.loading;

import com.google.inject.Inject;
import com.metamx.common.MapUtils;
import io.druid.segment.loading.DataSegmentMover;
import io.druid.segment.loading.SegmentLoadingException;
import io.druid.timeline.DataSegment;
import java.util.Map;

public class OmniDataSegmentMover
implements DataSegmentMover {
    private final Map<String, DataSegmentMover> movers;

    @Inject
    public OmniDataSegmentMover(Map<String, DataSegmentMover> movers) {
        this.movers = movers;
    }

    public DataSegment move(DataSegment segment, Map<String, Object> targetLoadSpec) throws SegmentLoadingException {
        return this.getMover(segment).move(segment, targetLoadSpec);
    }

    private DataSegmentMover getMover(DataSegment segment) throws SegmentLoadingException {
        String type = MapUtils.getString((Map)segment.getLoadSpec(), (String)"type");
        DataSegmentMover mover = this.movers.get(type);
        if (mover == null) {
            throw new SegmentLoadingException("Unknown loader type[%s].  Known types are %s", new Object[]{type, this.movers.keySet()});
        }
        return mover;
    }
}

