/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.loading;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.ByteStreams;
import com.google.common.io.Files;
import com.google.common.io.InputSupplier;
import com.google.inject.Inject;
import com.metamx.common.logger.Logger;
import io.druid.segment.SegmentUtils;
import io.druid.segment.loading.DataSegmentPusher;
import io.druid.segment.loading.DataSegmentPusherUtil;
import io.druid.segment.loading.LocalDataSegmentPusherConfig;
import io.druid.timeline.DataSegment;
import io.druid.utils.CompressionUtils;
import java.io.File;
import java.io.IOException;

public class LocalDataSegmentPusher
implements DataSegmentPusher {
    private static final Logger log = new Logger(LocalDataSegmentPusher.class);
    private final LocalDataSegmentPusherConfig config;
    private final ObjectMapper jsonMapper;

    @Inject
    public LocalDataSegmentPusher(LocalDataSegmentPusherConfig config, ObjectMapper jsonMapper) {
        this.config = config;
        this.jsonMapper = jsonMapper;
    }

    public String getPathForHadoop(String dataSource) {
        return String.format("file://%s/%s", this.config.getStorageDirectory(), dataSource);
    }

    public DataSegment push(File dataSegmentFile, DataSegment segment) throws IOException {
        File outDir = new File(this.config.getStorageDirectory(), DataSegmentPusherUtil.getStorageDir((DataSegment)segment));
        if (dataSegmentFile.equals(outDir)) {
            long size = 0L;
            for (File file : dataSegmentFile.listFiles()) {
                size += file.length();
            }
            return this.createDescriptorFile(segment.withLoadSpec(this.makeLoadSpec(outDir)).withSize(size).withBinaryVersion(SegmentUtils.getVersionFromDir((File)dataSegmentFile)), outDir);
        }
        outDir.mkdirs();
        File outFile = new File(outDir, "index.zip");
        log.info("Compressing files from[%s] to [%s]", new Object[]{dataSegmentFile, outFile});
        long size = CompressionUtils.zip((File)dataSegmentFile, (File)outFile);
        return this.createDescriptorFile(segment.withLoadSpec(this.makeLoadSpec(outFile)).withSize(size).withBinaryVersion(SegmentUtils.getVersionFromDir((File)dataSegmentFile)), outDir);
    }

    private DataSegment createDescriptorFile(DataSegment segment, File outDir) throws IOException {
        File descriptorFile = new File(outDir, "descriptor.json");
        log.info("Creating descriptor file at[%s]", new Object[]{descriptorFile});
        Files.copy((InputSupplier)ByteStreams.newInputStreamSupplier((byte[])this.jsonMapper.writeValueAsBytes((Object)segment)), (File)descriptorFile);
        return segment;
    }

    private ImmutableMap<String, Object> makeLoadSpec(File outFile) {
        return ImmutableMap.of((Object)"type", (Object)"local", (Object)"path", (Object)outFile.toString());
    }
}

