/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.loading;

import com.metamx.common.MapUtils;
import com.metamx.common.logger.Logger;
import io.druid.segment.loading.DataSegmentKiller;
import io.druid.segment.loading.SegmentLoadingException;
import io.druid.timeline.DataSegment;
import java.io.File;
import java.util.Map;

public class LocalDataSegmentKiller
implements DataSegmentKiller {
    private static final Logger log = new Logger(LocalDataSegmentKiller.class);

    public void kill(DataSegment segment) throws SegmentLoadingException {
        File path = this.getDirectory(segment);
        log.info("segment[%s] maps to path[%s]", new Object[]{segment.getIdentifier(), path});
        if (!path.isDirectory()) {
            if (!path.delete()) {
                log.error("Unable to delete file[%s].", new Object[]{path});
                throw new SegmentLoadingException("Couldn't kill segment[%s]", new Object[]{segment.getIdentifier()});
            }
            return;
        }
        File[] files = path.listFiles();
        int success = 0;
        for (File file : files) {
            if (!file.delete()) {
                log.error("Unable to delete file[%s].", new Object[]{file});
                continue;
            }
            ++success;
        }
        if (success == 0 && files.length != 0) {
            throw new SegmentLoadingException("Couldn't kill segment[%s]", new Object[]{segment.getIdentifier()});
        }
        if (success < files.length) {
            log.warn("Couldn't completely kill segment[%s]", new Object[]{segment.getIdentifier()});
        } else if (!path.delete()) {
            log.warn("Unable to delete directory[%s].", new Object[]{path});
            log.warn("Couldn't completely kill segment[%s]", new Object[]{segment.getIdentifier()});
        }
    }

    private File getDirectory(DataSegment segment) throws SegmentLoadingException {
        Map loadSpec = segment.getLoadSpec();
        File path = new File(MapUtils.getString((Map)loadSpec, (String)"path"));
        if (!path.exists()) {
            throw new SegmentLoadingException("Asked to load path[%s], but it doesn't exist.", new Object[]{path});
        }
        return path.getParentFile();
    }
}

