/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.indexing.granularity;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.metamx.common.Granularity;
import io.druid.granularity.QueryGranularity;
import io.druid.segment.indexing.granularity.ArbitraryGranularitySpec;
import io.druid.segment.indexing.granularity.GranularitySpec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.SortedSet;
import org.joda.time.DateTime;
import org.joda.time.Interval;

public class UniformGranularitySpec
implements GranularitySpec {
    private static final Granularity defaultSegmentGranularity = Granularity.DAY;
    private static final QueryGranularity defaultQueryGranularity = QueryGranularity.NONE;
    private final Granularity segmentGranularity;
    private final QueryGranularity queryGranularity;
    private final List<Interval> inputIntervals;
    private final ArbitraryGranularitySpec wrappedSpec;

    @JsonCreator
    public UniformGranularitySpec(@JsonProperty(value="segmentGranularity") Granularity segmentGranularity, @JsonProperty(value="queryGranularity") QueryGranularity queryGranularity, @JsonProperty(value="intervals") List<Interval> inputIntervals, @JsonProperty(value="gran") Granularity granularity) {
        this.segmentGranularity = segmentGranularity != null ? segmentGranularity : (granularity != null ? granularity : defaultSegmentGranularity);
        QueryGranularity queryGranularity2 = this.queryGranularity = queryGranularity == null ? defaultQueryGranularity : queryGranularity;
        if (inputIntervals != null) {
            ArrayList granularIntervals = Lists.newArrayList();
            for (Interval inputInterval : inputIntervals) {
                Iterables.addAll((Collection)granularIntervals, (Iterable)this.segmentGranularity.getIterable(inputInterval));
            }
            this.inputIntervals = ImmutableList.copyOf(inputIntervals);
            this.wrappedSpec = new ArbitraryGranularitySpec(queryGranularity, granularIntervals);
        } else {
            this.inputIntervals = null;
            this.wrappedSpec = null;
        }
    }

    @Override
    public Optional<SortedSet<Interval>> bucketIntervals() {
        if (this.wrappedSpec == null) {
            return Optional.absent();
        }
        return this.wrappedSpec.bucketIntervals();
    }

    @Override
    public Optional<Interval> bucketInterval(DateTime dt) {
        return this.wrappedSpec.bucketInterval(dt);
    }

    @Override
    @JsonProperty(value="segmentGranularity")
    public Granularity getSegmentGranularity() {
        return this.segmentGranularity;
    }

    @Override
    @JsonProperty(value="queryGranularity")
    public QueryGranularity getQueryGranularity() {
        return this.queryGranularity;
    }

    @Override
    public GranularitySpec withQueryGranularity(QueryGranularity queryGranularity) {
        return new UniformGranularitySpec(this.segmentGranularity, queryGranularity, this.inputIntervals, this.segmentGranularity);
    }

    @JsonProperty(value="intervals")
    public Optional<List<Interval>> getIntervals() {
        return Optional.fromNullable(this.inputIntervals);
    }
}

