/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.indexing;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.io.Files;
import io.druid.segment.indexing.TuningConfig;
import io.druid.segment.realtime.plumber.IntervalStartVersioningPolicy;
import io.druid.segment.realtime.plumber.RejectionPolicyFactory;
import io.druid.segment.realtime.plumber.ServerTimeRejectionPolicyFactory;
import io.druid.segment.realtime.plumber.VersioningPolicy;
import io.druid.timeline.partition.NoneShardSpec;
import io.druid.timeline.partition.ShardSpec;
import java.io.File;
import org.joda.time.Period;

public class RealtimeTuningConfig
implements TuningConfig {
    private static final int defaultMaxRowsInMemory = 500000;
    private static final Period defaultIntermediatePersistPeriod = new Period((Object)"PT10M");
    private static final Period defaultWindowPeriod = new Period((Object)"PT10M");
    private static final File defaultBasePersistDirectory = Files.createTempDir();
    private static final VersioningPolicy defaultVersioningPolicy = new IntervalStartVersioningPolicy();
    private static final RejectionPolicyFactory defaultRejectionPolicyFactory = new ServerTimeRejectionPolicyFactory();
    private static final int defaultMaxPendingPersists = 0;
    private static final ShardSpec defaultShardSpec = new NoneShardSpec();
    private final int maxRowsInMemory;
    private final Period intermediatePersistPeriod;
    private final Period windowPeriod;
    private final File basePersistDirectory;
    private final VersioningPolicy versioningPolicy;
    private final RejectionPolicyFactory rejectionPolicyFactory;
    private final int maxPendingPersists;
    private final ShardSpec shardSpec;

    public static RealtimeTuningConfig makeDefaultTuningConfig() {
        return new RealtimeTuningConfig(500000, defaultIntermediatePersistPeriod, defaultWindowPeriod, defaultBasePersistDirectory, defaultVersioningPolicy, defaultRejectionPolicyFactory, 0, defaultShardSpec);
    }

    @JsonCreator
    public RealtimeTuningConfig(@JsonProperty(value="maxRowsInMemory") Integer maxRowsInMemory, @JsonProperty(value="intermediatePersistPeriod") Period intermediatePersistPeriod, @JsonProperty(value="windowPeriod") Period windowPeriod, @JsonProperty(value="basePersistDirectory") File basePersistDirectory, @JsonProperty(value="versioningPolicy") VersioningPolicy versioningPolicy, @JsonProperty(value="rejectionPolicy") RejectionPolicyFactory rejectionPolicyFactory, @JsonProperty(value="maxPendingPersists") Integer maxPendingPersists, @JsonProperty(value="shardSpec") ShardSpec shardSpec) {
        this.maxRowsInMemory = maxRowsInMemory == null ? 500000 : maxRowsInMemory;
        this.intermediatePersistPeriod = intermediatePersistPeriod == null ? defaultIntermediatePersistPeriod : intermediatePersistPeriod;
        this.windowPeriod = windowPeriod == null ? defaultWindowPeriod : windowPeriod;
        this.basePersistDirectory = basePersistDirectory == null ? defaultBasePersistDirectory : basePersistDirectory;
        this.versioningPolicy = versioningPolicy == null ? defaultVersioningPolicy : versioningPolicy;
        this.rejectionPolicyFactory = rejectionPolicyFactory == null ? defaultRejectionPolicyFactory : rejectionPolicyFactory;
        this.maxPendingPersists = maxPendingPersists == null ? 0 : maxPendingPersists;
        this.shardSpec = shardSpec == null ? defaultShardSpec : shardSpec;
    }

    @JsonProperty
    public int getMaxRowsInMemory() {
        return this.maxRowsInMemory;
    }

    @JsonProperty
    public Period getIntermediatePersistPeriod() {
        return this.intermediatePersistPeriod;
    }

    @JsonProperty
    public Period getWindowPeriod() {
        return this.windowPeriod;
    }

    @JsonProperty
    public File getBasePersistDirectory() {
        return this.basePersistDirectory;
    }

    @JsonProperty
    public VersioningPolicy getVersioningPolicy() {
        return this.versioningPolicy;
    }

    @JsonProperty
    public RejectionPolicyFactory getRejectionPolicyFactory() {
        return this.rejectionPolicyFactory;
    }

    @JsonProperty
    public int getMaxPendingPersists() {
        return this.maxPendingPersists;
    }

    @JsonProperty
    public ShardSpec getShardSpec() {
        return this.shardSpec;
    }

    public RealtimeTuningConfig withVersioningPolicy(VersioningPolicy policy) {
        return new RealtimeTuningConfig(this.maxRowsInMemory, this.intermediatePersistPeriod, this.windowPeriod, this.basePersistDirectory, policy, this.rejectionPolicyFactory, this.maxPendingPersists, this.shardSpec);
    }

    public RealtimeTuningConfig withBasePersistDirectory(File dir) {
        return new RealtimeTuningConfig(this.maxRowsInMemory, this.intermediatePersistPeriod, this.windowPeriod, dir, this.versioningPolicy, this.rejectionPolicyFactory, this.maxPendingPersists, this.shardSpec);
    }
}

