/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.indexing;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.druid.data.input.impl.InputRowParser;
import io.druid.query.aggregation.AggregatorFactory;
import io.druid.segment.indexing.granularity.GranularitySpec;
import io.druid.segment.indexing.granularity.UniformGranularitySpec;

public class DataSchema {
    private final String dataSource;
    private final InputRowParser parser;
    private final AggregatorFactory[] aggregators;
    private final GranularitySpec granularitySpec;

    @JsonCreator
    public DataSchema(@JsonProperty(value="dataSource") String dataSource, @JsonProperty(value="parser") InputRowParser parser, @JsonProperty(value="metricsSpec") AggregatorFactory[] aggregators, @JsonProperty(value="granularitySpec") GranularitySpec granularitySpec) {
        this.dataSource = dataSource;
        this.parser = parser;
        this.aggregators = aggregators;
        this.granularitySpec = granularitySpec == null ? new UniformGranularitySpec(null, null, null, null) : granularitySpec;
    }

    @JsonProperty
    public String getDataSource() {
        return this.dataSource;
    }

    @JsonProperty
    public InputRowParser getParser() {
        return this.parser;
    }

    @JsonProperty(value="metricsSpec")
    public AggregatorFactory[] getAggregators() {
        return this.aggregators;
    }

    @JsonProperty
    public GranularitySpec getGranularitySpec() {
        return this.granularitySpec;
    }

    public DataSchema withGranularitySpec(GranularitySpec granularitySpec) {
        return new DataSchema(this.dataSource, this.parser, this.aggregators, granularitySpec);
    }
}

