/*
 * Decompiled with CFR 0.152.
 */
package io.druid.guice.http;

import com.google.common.base.Supplier;
import com.google.inject.Binding;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Provider;
import com.google.inject.TypeLiteral;
import com.metamx.common.lifecycle.Lifecycle;
import io.druid.guice.http.DruidHttpClientConfig;
import java.lang.annotation.Annotation;
import javax.net.ssl.SSLContext;

public abstract class AbstractHttpClientProvider<HttpClientType>
implements Provider<HttpClientType> {
    private final Key<Supplier<DruidHttpClientConfig>> configKey;
    private final Key<SSLContext> sslContextKey;
    private Provider<Supplier<DruidHttpClientConfig>> configProvider;
    private Provider<Lifecycle> lifecycleProvider;
    private Binding<SSLContext> sslContextBinding;

    public AbstractHttpClientProvider() {
        this.configKey = Key.get((TypeLiteral)new TypeLiteral<Supplier<DruidHttpClientConfig>>(){});
        this.sslContextKey = Key.get(SSLContext.class);
    }

    public AbstractHttpClientProvider(Annotation annotation) {
        this.configKey = Key.get((TypeLiteral)new TypeLiteral<Supplier<DruidHttpClientConfig>>(){}, (Annotation)annotation);
        this.sslContextKey = Key.get(SSLContext.class, (Annotation)annotation);
    }

    public AbstractHttpClientProvider(Class<? extends Annotation> annotation) {
        this.configKey = Key.get((TypeLiteral)new TypeLiteral<Supplier<DruidHttpClientConfig>>(){}, annotation);
        this.sslContextKey = Key.get(SSLContext.class, annotation);
    }

    @Inject
    public void configure(Injector injector) {
        this.configProvider = injector.getProvider(this.configKey);
        this.sslContextBinding = injector.getExistingBinding(this.sslContextKey);
        this.lifecycleProvider = injector.getProvider(Lifecycle.class);
    }

    public Key<Supplier<DruidHttpClientConfig>> getConfigKey() {
        return this.configKey;
    }

    public Key<SSLContext> getSslContextKey() {
        return this.sslContextKey;
    }

    public Provider<Supplier<DruidHttpClientConfig>> getConfigProvider() {
        return this.configProvider;
    }

    public Provider<Lifecycle> getLifecycleProvider() {
        return this.lifecycleProvider;
    }

    public Binding<SSLContext> getSslContextBinding() {
        return this.sslContextBinding;
    }
}

