/*
 * Decompiled with CFR 0.152.
 */
package io.druid.guice;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.jsontype.NamedType;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.google.inject.Binder;
import com.google.inject.Provides;
import com.metamx.common.concurrent.ScheduledExecutorFactory;
import com.metamx.common.concurrent.ScheduledExecutors;
import com.metamx.common.lifecycle.Lifecycle;
import io.druid.guice.ConfigProvider;
import io.druid.guice.JsonConfigProvider;
import io.druid.guice.LazySingleton;
import io.druid.guice.annotations.Self;
import io.druid.initialization.DruidModule;
import io.druid.server.DruidNode;
import io.druid.server.initialization.ZkPathsConfig;
import io.druid.timeline.partition.HashBasedNumberedShardSpec;
import io.druid.timeline.partition.LinearShardSpec;
import io.druid.timeline.partition.NumberedShardSpec;
import io.druid.timeline.partition.SingleDimensionShardSpec;
import java.util.Arrays;
import java.util.List;

public class ServerModule
implements DruidModule {
    public void configure(Binder binder) {
        ConfigProvider.bind((Binder)binder, ZkPathsConfig.class);
        JsonConfigProvider.bind((Binder)binder, (String)"druid", DruidNode.class, Self.class);
    }

    @Provides
    @LazySingleton
    public ScheduledExecutorFactory getScheduledExecutorFactory(Lifecycle lifecycle) {
        return ScheduledExecutors.createFactory((Lifecycle)lifecycle);
    }

    public List<? extends Module> getJacksonModules() {
        return Arrays.asList(new SimpleModule().registerSubtypes(new NamedType[]{new NamedType(SingleDimensionShardSpec.class, "single"), new NamedType(LinearShardSpec.class, "linear"), new NamedType(NumberedShardSpec.class, "numbered"), new NamedType(HashBasedNumberedShardSpec.class, "hashed")}));
    }
}

