/*
 * Decompiled with CFR 0.152.
 */
package io.druid.guice;

import com.google.common.collect.ImmutableMap;
import com.google.inject.Binder;
import com.google.inject.multibindings.MapBinder;
import io.druid.guice.DruidBinders;
import io.druid.guice.LazySingleton;
import io.druid.guice.QueryToolChestModule;
import io.druid.query.Query;
import io.druid.query.QueryRunnerFactory;
import io.druid.query.QueryWatcher;
import io.druid.query.groupby.GroupByQuery;
import io.druid.query.groupby.GroupByQueryEngine;
import io.druid.query.groupby.GroupByQueryRunnerFactory;
import io.druid.query.metadata.SegmentMetadataQueryRunnerFactory;
import io.druid.query.metadata.metadata.SegmentMetadataQuery;
import io.druid.query.search.SearchQueryRunnerFactory;
import io.druid.query.search.search.SearchQuery;
import io.druid.query.select.SelectQuery;
import io.druid.query.select.SelectQueryRunnerFactory;
import io.druid.query.timeboundary.TimeBoundaryQuery;
import io.druid.query.timeboundary.TimeBoundaryQueryRunnerFactory;
import io.druid.query.timeseries.TimeseriesQuery;
import io.druid.query.timeseries.TimeseriesQueryRunnerFactory;
import io.druid.query.topn.TopNQuery;
import io.druid.query.topn.TopNQueryRunnerFactory;
import io.druid.server.QueryManager;
import java.util.Map;

public class QueryRunnerFactoryModule
extends QueryToolChestModule {
    private static final Map<Class<? extends Query>, Class<? extends QueryRunnerFactory>> mappings = ImmutableMap.builder().put(TimeseriesQuery.class, TimeseriesQueryRunnerFactory.class).put(SearchQuery.class, SearchQueryRunnerFactory.class).put(TimeBoundaryQuery.class, TimeBoundaryQueryRunnerFactory.class).put(SegmentMetadataQuery.class, SegmentMetadataQueryRunnerFactory.class).put(GroupByQuery.class, GroupByQueryRunnerFactory.class).put(SelectQuery.class, SelectQueryRunnerFactory.class).put(TopNQuery.class, TopNQueryRunnerFactory.class).build();

    @Override
    public void configure(Binder binder) {
        super.configure(binder);
        binder.bind(QueryWatcher.class).to(QueryManager.class).in(LazySingleton.class);
        binder.bind(QueryManager.class).in(LazySingleton.class);
        MapBinder<Class<? extends Query>, QueryRunnerFactory> queryFactoryBinder = DruidBinders.queryRunnerFactoryBinder(binder);
        for (Map.Entry<Class<? extends Query>, Class<? extends QueryRunnerFactory>> entry : mappings.entrySet()) {
            queryFactoryBinder.addBinding(entry.getKey()).to(entry.getValue());
            binder.bind(entry.getValue()).in(LazySingleton.class);
        }
        binder.bind(GroupByQueryEngine.class).in(LazySingleton.class);
    }
}

