/*
 * Decompiled with CFR 0.152.
 */
package io.druid.guice;

import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.ProvisionException;
import com.metamx.common.concurrent.ExecutorServiceConfig;
import com.metamx.common.lifecycle.Lifecycle;
import com.metamx.common.logger.Logger;
import com.metamx.emitter.service.ServiceEmitter;
import com.metamx.emitter.service.ServiceMetricEvent;
import io.druid.collections.StupidPool;
import io.druid.common.utils.VMUtils;
import io.druid.guice.ConfigProvider;
import io.druid.guice.LazySingleton;
import io.druid.guice.ManageLifecycle;
import io.druid.guice.annotations.Global;
import io.druid.guice.annotations.Processing;
import io.druid.query.DruidProcessingConfig;
import io.druid.query.MetricsEmittingExecutorService;
import io.druid.query.PrioritizedExecutorService;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicLong;

public class DruidProcessingModule
implements Module {
    private static final Logger log = new Logger(DruidProcessingModule.class);

    public void configure(Binder binder) {
        ConfigProvider.bind((Binder)binder, DruidProcessingConfig.class, (Map)ImmutableMap.of((Object)"base_path", (Object)"druid.processing"));
        binder.bind(ExecutorServiceConfig.class).to(DruidProcessingConfig.class);
    }

    @Provides
    @Processing
    @ManageLifecycle
    public ExecutorService getProcessingExecutorService(ExecutorServiceConfig config, ServiceEmitter emitter, Lifecycle lifecycle) {
        return new MetricsEmittingExecutorService((ListeningExecutorService)PrioritizedExecutorService.create((Lifecycle)lifecycle, (ExecutorServiceConfig)config), emitter, new ServiceMetricEvent.Builder());
    }

    @Provides
    @LazySingleton
    @Global
    public StupidPool<ByteBuffer> getIntermediateResultsPool(DruidProcessingConfig config) {
        try {
            long maxDirectMemory = VMUtils.getMaxDirectMemory();
            long memoryNeeded = (long)config.intermediateComputeSizeBytes() * (long)(config.getNumThreads() + 1);
            if (maxDirectMemory < memoryNeeded) {
                throw new ProvisionException(String.format("Not enough direct memory.  Please adjust -XX:MaxDirectMemorySize, druid.processing.buffer.sizeBytes, or druid.processing.numThreads: maxDirectMemory[%,d], memoryNeeded[%,d] = druid.processing.buffer.sizeBytes[%,d] * ( druid.processing.numThreads[%,d] + 1 )", maxDirectMemory, memoryNeeded, config.intermediateComputeSizeBytes(), config.getNumThreads()));
            }
        }
        catch (UnsupportedOperationException e) {
            log.info(e.getMessage(), new Object[0]);
        }
        catch (RuntimeException e) {
            log.warn((Throwable)e, e.getMessage(), new Object[0]);
        }
        return new IntermediateProcessingBufferPool(config.intermediateComputeSizeBytes());
    }

    private static class IntermediateProcessingBufferPool
    extends StupidPool<ByteBuffer> {
        private static final Logger log = new Logger(IntermediateProcessingBufferPool.class);

        public IntermediateProcessingBufferPool(final int computationBufferSize) {
            super((Supplier)new Supplier<ByteBuffer>(){
                final AtomicLong count = new AtomicLong(0L);

                public ByteBuffer get() {
                    log.info("Allocating new intermediate processing buffer[%,d] of size[%,d]", new Object[]{this.count.getAndIncrement(), computationBufferSize});
                    return ByteBuffer.allocateDirect(computationBufferSize);
                }
            });
        }
    }
}

