/*
 * Decompiled with CFR 0.152.
 */
package io.druid.db;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import com.google.inject.Inject;
import com.metamx.common.MapUtils;
import com.metamx.common.concurrent.ScheduledExecutors;
import com.metamx.common.lifecycle.LifecycleStart;
import com.metamx.common.lifecycle.LifecycleStop;
import com.metamx.common.logger.Logger;
import io.druid.client.DruidDataSource;
import io.druid.concurrent.Execs;
import io.druid.db.DatabaseSegmentManagerConfig;
import io.druid.db.DbTablesConfig;
import io.druid.guice.ManageLifecycle;
import io.druid.timeline.DataSegment;
import io.druid.timeline.TimelineObjectHolder;
import io.druid.timeline.VersionedIntervalTimeline;
import io.druid.timeline.partition.PartitionChunk;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicReference;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.joda.time.Interval;
import org.skife.jdbi.v2.Batch;
import org.skife.jdbi.v2.FoldController;
import org.skife.jdbi.v2.Folder3;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.IDBI;
import org.skife.jdbi.v2.Query;
import org.skife.jdbi.v2.StatementContext;
import org.skife.jdbi.v2.Update;
import org.skife.jdbi.v2.tweak.HandleCallback;

@ManageLifecycle
public class DatabaseSegmentManager {
    private static final Logger log = new Logger(DatabaseSegmentManager.class);
    private final Object lock = new Object();
    private final ObjectMapper jsonMapper;
    private final Supplier<DatabaseSegmentManagerConfig> config;
    private final Supplier<DbTablesConfig> dbTables;
    private final AtomicReference<ConcurrentHashMap<String, DruidDataSource>> dataSources;
    private final IDBI dbi;
    private volatile ScheduledExecutorService exec;
    private volatile boolean started = false;

    @Inject
    public DatabaseSegmentManager(ObjectMapper jsonMapper, Supplier<DatabaseSegmentManagerConfig> config, Supplier<DbTablesConfig> dbTables, IDBI dbi) {
        this.jsonMapper = jsonMapper;
        this.config = config;
        this.dbTables = dbTables;
        this.dataSources = new AtomicReference(new ConcurrentHashMap());
        this.dbi = dbi;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @LifecycleStart
    public void start() {
        Object object = this.lock;
        synchronized (object) {
            if (this.started) {
                return;
            }
            this.exec = Execs.scheduledSingleThreaded((String)"DatabaseSegmentManager-Exec--%d");
            Duration delay = ((DatabaseSegmentManagerConfig)this.config.get()).getPollDuration().toStandardDuration();
            ScheduledExecutors.scheduleWithFixedDelay((ScheduledExecutorService)this.exec, (Duration)new Duration(0L), (Duration)delay, (Runnable)new Runnable(){

                @Override
                public void run() {
                    DatabaseSegmentManager.this.poll();
                }
            });
            this.started = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @LifecycleStop
    public void stop() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.started) {
                return;
            }
            this.started = false;
            this.dataSources.set(new ConcurrentHashMap());
            this.exec.shutdownNow();
            this.exec = null;
        }
    }

    public boolean enableDatasource(final String ds) {
        try {
            VersionedIntervalTimeline segmentTimeline = (VersionedIntervalTimeline)this.dbi.withHandle((HandleCallback)new HandleCallback<VersionedIntervalTimeline<String, DataSegment>>(){

                public VersionedIntervalTimeline<String, DataSegment> withHandle(Handle handle) throws Exception {
                    return (VersionedIntervalTimeline)((Query)handle.createQuery(String.format("SELECT payload FROM %s WHERE dataSource = :dataSource", DatabaseSegmentManager.this.getSegmentsTable())).bind("dataSource", ds)).fold((Object)new VersionedIntervalTimeline((Comparator)Ordering.natural()), (Folder3)new Folder3<VersionedIntervalTimeline<String, DataSegment>, Map<String, Object>>(){

                        public VersionedIntervalTimeline<String, DataSegment> fold(VersionedIntervalTimeline<String, DataSegment> timeline, Map<String, Object> stringObjectMap, FoldController foldController, StatementContext statementContext) throws SQLException {
                            try {
                                DataSegment segment = (DataSegment)DatabaseSegmentManager.this.jsonMapper.readValue((String)stringObjectMap.get("payload"), DataSegment.class);
                                timeline.add(segment.getInterval(), (Object)segment.getVersion(), segment.getShardSpec().createChunk((Object)segment));
                                return timeline;
                            }
                            catch (Exception e) {
                                throw new SQLException(e.toString());
                            }
                        }
                    });
                }
            });
            final ArrayList segments = Lists.newArrayList();
            for (TimelineObjectHolder objectHolder : segmentTimeline.lookup(new Interval((Object)"0000-01-01/3000-01-01"))) {
                for (PartitionChunk partitionChunk : objectHolder.getObject()) {
                    segments.add(partitionChunk.getObject());
                }
            }
            if (segments.isEmpty()) {
                log.warn("No segments found in the database!", new Object[0]);
                return false;
            }
            this.dbi.withHandle((HandleCallback)new HandleCallback<Void>(){

                public Void withHandle(Handle handle) throws Exception {
                    Batch batch = handle.createBatch();
                    for (DataSegment segment : segments) {
                        batch.add(String.format("UPDATE %s SET used=true WHERE id = '%s'", DatabaseSegmentManager.this.getSegmentsTable(), segment.getIdentifier()));
                    }
                    batch.execute();
                    return null;
                }
            });
        }
        catch (Exception e) {
            log.error((Throwable)e, "Exception enabling datasource %s", new Object[]{ds});
            return false;
        }
        return true;
    }

    public boolean enableSegment(final String segmentId) {
        try {
            this.dbi.withHandle((HandleCallback)new HandleCallback<Void>(){

                public Void withHandle(Handle handle) throws Exception {
                    ((Update)handle.createStatement(String.format("UPDATE %s SET used=true WHERE id = :id", DatabaseSegmentManager.this.getSegmentsTable())).bind("id", segmentId)).execute();
                    return null;
                }
            });
        }
        catch (Exception e) {
            log.error((Throwable)e, "Exception enabling segment %s", new Object[]{segmentId});
            return false;
        }
        return true;
    }

    public boolean removeDatasource(final String ds) {
        try {
            ConcurrentHashMap<String, DruidDataSource> dataSourceMap = this.dataSources.get();
            if (!dataSourceMap.containsKey(ds)) {
                log.warn("Cannot delete datasource %s, does not exist", new Object[]{ds});
                return false;
            }
            this.dbi.withHandle((HandleCallback)new HandleCallback<Void>(){

                public Void withHandle(Handle handle) throws Exception {
                    ((Update)handle.createStatement(String.format("UPDATE %s SET used=false WHERE dataSource = :dataSource", DatabaseSegmentManager.this.getSegmentsTable())).bind("dataSource", ds)).execute();
                    return null;
                }
            });
            dataSourceMap.remove(ds);
        }
        catch (Exception e) {
            log.error((Throwable)e, "Error removing datasource %s", new Object[]{ds});
            return false;
        }
        return true;
    }

    public boolean removeSegment(String ds, final String segmentID) {
        try {
            this.dbi.withHandle((HandleCallback)new HandleCallback<Void>(){

                public Void withHandle(Handle handle) throws Exception {
                    ((Update)handle.createStatement(String.format("UPDATE %s SET used=false WHERE id = :segmentID", DatabaseSegmentManager.this.getSegmentsTable())).bind("segmentID", segmentID)).execute();
                    return null;
                }
            });
            ConcurrentHashMap<String, DruidDataSource> dataSourceMap = this.dataSources.get();
            if (!dataSourceMap.containsKey(ds)) {
                log.warn("Cannot find datasource %s", new Object[]{ds});
                return false;
            }
            DruidDataSource dataSource = dataSourceMap.get(ds);
            dataSource.removePartition(segmentID);
            if (dataSource.isEmpty()) {
                dataSourceMap.remove(ds);
            }
        }
        catch (Exception e) {
            log.error((Throwable)e, e.toString(), new Object[0]);
            return false;
        }
        return true;
    }

    public boolean isStarted() {
        return this.started;
    }

    public DruidDataSource getInventoryValue(String key) {
        return this.dataSources.get().get(key);
    }

    public Collection<DruidDataSource> getInventory() {
        return this.dataSources.get().values();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<String> getAllDatasourceNames() {
        Object object = this.lock;
        synchronized (object) {
            return (Collection)this.dbi.withHandle((HandleCallback)new HandleCallback<List<String>>(){

                public List<String> withHandle(Handle handle) throws Exception {
                    return (List)handle.createQuery(String.format("SELECT DISTINCT(datasource) FROM %s", DatabaseSegmentManager.this.getSegmentsTable())).fold((Object)Lists.newArrayList(), (Folder3)new Folder3<ArrayList<String>, Map<String, Object>>(){

                        public ArrayList<String> fold(ArrayList<String> druidDataSources, Map<String, Object> stringObjectMap, FoldController foldController, StatementContext statementContext) throws SQLException {
                            druidDataSources.add(MapUtils.getString(stringObjectMap, (String)"datasource"));
                            return druidDataSources;
                        }
                    });
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void poll() {
        try {
            if (!this.started) {
                return;
            }
            ConcurrentHashMap<String, DruidDataSource> newDataSources = new ConcurrentHashMap<String, DruidDataSource>();
            List segmentRows = (List)this.dbi.withHandle((HandleCallback)new HandleCallback<List<Map<String, Object>>>(){

                public List<Map<String, Object>> withHandle(Handle handle) throws Exception {
                    return handle.createQuery(String.format("SELECT payload FROM %s WHERE used=true", DatabaseSegmentManager.this.getSegmentsTable())).list();
                }
            });
            if (segmentRows == null || segmentRows.isEmpty()) {
                log.warn("No segments found in the database!", new Object[0]);
                return;
            }
            log.info("Polled and found %,d segments in the database", new Object[]{segmentRows.size()});
            for (Map segmentRow : segmentRows) {
                DruidDataSource shouldBeNull;
                DataSegment segment = (DataSegment)this.jsonMapper.readValue((String)segmentRow.get("payload"), DataSegment.class);
                String datasourceName = segment.getDataSource();
                DruidDataSource dataSource = (DruidDataSource)newDataSources.get(datasourceName);
                if (dataSource == null && (shouldBeNull = newDataSources.put(datasourceName, dataSource = new DruidDataSource(datasourceName, (Map<String, String>)ImmutableMap.of((Object)"created", (Object)new DateTime().toString())))) != null) {
                    log.warn("Just put key[%s] into dataSources and what was there wasn't null!?  It was[%s]", new Object[]{datasourceName, shouldBeNull});
                }
                if (dataSource.getSegments().contains(segment)) continue;
                dataSource.addSegment(segment.getIdentifier(), segment);
            }
            Object object = this.lock;
            synchronized (object) {
                if (this.started) {
                    this.dataSources.set(newDataSources);
                }
            }
        }
        catch (Exception e) {
            log.error((Throwable)e, "Problem polling DB.", new Object[0]);
        }
    }

    private String getSegmentsTable() {
        return ((DbTablesConfig)this.dbTables.get()).getSegmentsTable();
    }
}

