/*
 * Decompiled with CFR 0.152.
 */
package io.druid.db;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Supplier;
import com.google.common.base.Throwables;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.metamx.common.lifecycle.Lifecycle;
import io.druid.db.DatabaseRuleManager;
import io.druid.db.DatabaseRuleManagerConfig;
import io.druid.db.DbConnector;
import io.druid.db.DbTablesConfig;
import org.skife.jdbi.v2.IDBI;

public class DatabaseRuleManagerProvider
implements Provider<DatabaseRuleManager> {
    private final ObjectMapper jsonMapper;
    private final Supplier<DatabaseRuleManagerConfig> config;
    private final Supplier<DbTablesConfig> dbTables;
    private final DbConnector dbConnector;
    private final Lifecycle lifecycle;

    @Inject
    public DatabaseRuleManagerProvider(ObjectMapper jsonMapper, Supplier<DatabaseRuleManagerConfig> config, Supplier<DbTablesConfig> dbTables, DbConnector dbConnector, Lifecycle lifecycle) {
        this.jsonMapper = jsonMapper;
        this.config = config;
        this.dbTables = dbTables;
        this.dbConnector = dbConnector;
        this.lifecycle = lifecycle;
    }

    public DatabaseRuleManager get() {
        try {
            this.lifecycle.addMaybeStartHandler(new Lifecycle.Handler(){

                public void start() throws Exception {
                    DatabaseRuleManagerProvider.this.dbConnector.createRulesTable();
                    DatabaseRuleManager.createDefaultRule((IDBI)DatabaseRuleManagerProvider.this.dbConnector.getDBI(), ((DbTablesConfig)DatabaseRuleManagerProvider.this.dbTables.get()).getRulesTable(), ((DatabaseRuleManagerConfig)DatabaseRuleManagerProvider.this.config.get()).getDefaultRule(), DatabaseRuleManagerProvider.this.jsonMapper);
                }

                public void stop() {
                }
            });
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
        return new DatabaseRuleManager(this.jsonMapper, this.config, this.dbTables, (IDBI)this.dbConnector.getDBI());
    }
}

