/*
 * Decompiled with CFR 0.152.
 */
package io.druid.db;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Supplier;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import com.metamx.common.MapUtils;
import com.metamx.common.concurrent.ScheduledExecutors;
import com.metamx.common.lifecycle.LifecycleStart;
import com.metamx.common.lifecycle.LifecycleStop;
import com.metamx.common.logger.Logger;
import io.druid.concurrent.Execs;
import io.druid.db.DatabaseRuleManagerConfig;
import io.druid.db.DbTablesConfig;
import io.druid.guice.ManageLifecycle;
import io.druid.guice.annotations.Json;
import io.druid.server.coordinator.rules.ForeverLoadRule;
import io.druid.server.coordinator.rules.Rule;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicReference;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.skife.jdbi.v2.FoldController;
import org.skife.jdbi.v2.Folder3;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.IDBI;
import org.skife.jdbi.v2.Query;
import org.skife.jdbi.v2.StatementContext;
import org.skife.jdbi.v2.Update;
import org.skife.jdbi.v2.tweak.HandleCallback;

@ManageLifecycle
public class DatabaseRuleManager {
    private static final Logger log = new Logger(DatabaseRuleManager.class);
    private final ObjectMapper jsonMapper;
    private final Supplier<DatabaseRuleManagerConfig> config;
    private final Supplier<DbTablesConfig> dbTables;
    private final IDBI dbi;
    private final AtomicReference<ImmutableMap<String, List<Rule>>> rules;
    private volatile ScheduledExecutorService exec;
    private final Object lock = new Object();
    private volatile boolean started = false;

    public static void createDefaultRule(IDBI dbi, final String ruleTable, final String defaultDatasourceName, final ObjectMapper jsonMapper) {
        try {
            dbi.withHandle((HandleCallback)new HandleCallback<Void>(){

                public Void withHandle(Handle handle) throws Exception {
                    List existing = ((Query)handle.createQuery(String.format("SELECT id from %s where datasource=:dataSource;", ruleTable)).bind("dataSource", defaultDatasourceName)).list();
                    if (!existing.isEmpty()) {
                        return null;
                    }
                    List<Rule> defaultRules = Arrays.asList(new ForeverLoadRule((Map<String, Integer>)ImmutableMap.of((Object)"_default_tier", (Object)2)));
                    String version = new DateTime().toString();
                    ((Update)((Update)((Update)((Update)handle.createStatement(String.format("INSERT INTO %s (id, dataSource, version, payload) VALUES (:id, :dataSource, :version, :payload)", ruleTable)).bind("id", String.format("%s_%s", defaultDatasourceName, version))).bind("dataSource", defaultDatasourceName)).bind("version", version)).bind("payload", jsonMapper.writeValueAsString(defaultRules))).execute();
                    return null;
                }
            });
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    @Inject
    public DatabaseRuleManager(@Json ObjectMapper jsonMapper, Supplier<DatabaseRuleManagerConfig> config, Supplier<DbTablesConfig> dbTables, IDBI dbi) {
        this.jsonMapper = jsonMapper;
        this.config = config;
        this.dbTables = dbTables;
        this.dbi = dbi;
        this.rules = new AtomicReference<ImmutableMap>(ImmutableMap.of());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @LifecycleStart
    public void start() {
        Object object = this.lock;
        synchronized (object) {
            if (this.started) {
                return;
            }
            this.exec = Execs.scheduledSingleThreaded((String)"DatabaseRuleManager-Exec--%d");
            DatabaseRuleManager.createDefaultRule(this.dbi, this.getRulesTable(), ((DatabaseRuleManagerConfig)this.config.get()).getDefaultRule(), this.jsonMapper);
            ScheduledExecutors.scheduleWithFixedDelay((ScheduledExecutorService)this.exec, (Duration)new Duration(0L), (Duration)((DatabaseRuleManagerConfig)this.config.get()).getPollDuration().toStandardDuration(), (Runnable)new Runnable(){

                @Override
                public void run() {
                    DatabaseRuleManager.this.poll();
                }
            });
            this.started = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @LifecycleStop
    public void stop() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.started) {
                return;
            }
            this.rules.set((ImmutableMap<String, List<Rule>>)ImmutableMap.of());
            this.started = false;
            this.exec.shutdownNow();
            this.exec = null;
        }
    }

    public void poll() {
        try {
            ImmutableMap newRules = ImmutableMap.copyOf((Map)((Map)this.dbi.withHandle((HandleCallback)new HandleCallback<Map<String, List<Rule>>>(){

                public Map<String, List<Rule>> withHandle(Handle handle) throws Exception {
                    return (Map)handle.createQuery(String.format("SELECT r.dataSource, r.payload FROM %1$s r INNER JOIN(SELECT dataSource, max(version) as version FROM %1$s GROUP BY dataSource) ds ON r.datasource = ds.datasource and r.version = ds.version", DatabaseRuleManager.this.getRulesTable())).fold((Object)Maps.newHashMap(), (Folder3)new Folder3<Map<String, List<Rule>>, Map<String, Object>>(){

                        public Map<String, List<Rule>> fold(Map<String, List<Rule>> retVal, Map<String, Object> stringObjectMap, FoldController foldController, StatementContext statementContext) throws SQLException {
                            try {
                                String dataSource = MapUtils.getString(stringObjectMap, (String)"dataSource");
                                List rules = (List)DatabaseRuleManager.this.jsonMapper.readValue(MapUtils.getString(stringObjectMap, (String)"payload"), (TypeReference)new TypeReference<List<Rule>>(){});
                                retVal.put(dataSource, rules);
                                return retVal;
                            }
                            catch (Exception e) {
                                throw Throwables.propagate((Throwable)e);
                            }
                        }
                    });
                }
            })));
            log.info("Polled and found rules for %,d datasource(s)", new Object[]{newRules.size()});
            this.rules.set((ImmutableMap<String, List<Rule>>)newRules);
        }
        catch (Exception e) {
            log.error((Throwable)e, "Exception while polling for rules", new Object[0]);
        }
    }

    public Map<String, List<Rule>> getAllRules() {
        return (Map)this.rules.get();
    }

    public List<Rule> getRules(String dataSource) {
        List retVal = (List)this.rules.get().get((Object)dataSource);
        return retVal == null ? Lists.newArrayList() : retVal;
    }

    public List<Rule> getRulesWithDefault(String dataSource) {
        ArrayList retVal = Lists.newArrayList();
        Map theRules = (Map)this.rules.get();
        if (theRules.get(dataSource) != null) {
            retVal.addAll((Collection)theRules.get(dataSource));
        }
        if (theRules.get(((DatabaseRuleManagerConfig)this.config.get()).getDefaultRule()) != null) {
            retVal.addAll((Collection)theRules.get(((DatabaseRuleManagerConfig)this.config.get()).getDefaultRule()));
        }
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean overrideRule(final String dataSource, final List<Rule> newRules) {
        Object object = this.lock;
        synchronized (object) {
            try {
                this.dbi.withHandle((HandleCallback)new HandleCallback<Void>(){

                    public Void withHandle(Handle handle) throws Exception {
                        String version = new DateTime().toString();
                        ((Update)((Update)((Update)((Update)handle.createStatement(String.format("INSERT INTO %s (id, dataSource, version, payload) VALUES (:id, :dataSource, :version, :payload)", DatabaseRuleManager.this.getRulesTable())).bind("id", String.format("%s_%s", dataSource, version))).bind("dataSource", dataSource)).bind("version", version)).bind("payload", DatabaseRuleManager.this.jsonMapper.writeValueAsString((Object)newRules))).execute();
                        return null;
                    }
                });
            }
            catch (Exception e) {
                log.error((Throwable)e, String.format("Exception while overriding rule for %s", dataSource), new Object[0]);
                return false;
            }
        }
        return true;
    }

    private String getRulesTable() {
        return ((DbTablesConfig)this.dbTables.get()).getRulesTable();
    }
}

