/*
 * Decompiled with CFR 0.152.
 */
package io.druid.curator.discovery;

import com.metamx.common.lifecycle.LifecycleStart;
import com.metamx.common.lifecycle.LifecycleStop;
import com.metamx.common.logger.Logger;
import io.druid.client.selector.DiscoverySelector;
import io.druid.client.selector.Server;
import java.io.IOException;
import org.apache.curator.x.discovery.ServiceInstance;
import org.apache.curator.x.discovery.ServiceProvider;

public class ServerDiscoverySelector
implements DiscoverySelector<Server> {
    private static final Logger log = new Logger(ServerDiscoverySelector.class);
    private final ServiceProvider serviceProvider;

    public ServerDiscoverySelector(ServiceProvider serviceProvider) {
        this.serviceProvider = serviceProvider;
    }

    @Override
    public Server pick() {
        ServiceInstance instance;
        try {
            instance = this.serviceProvider.getInstance();
        }
        catch (Exception e) {
            log.info((Throwable)e, "Exception getting instance", new Object[0]);
            return null;
        }
        if (instance == null) {
            log.error("No server instance found", new Object[0]);
            return null;
        }
        return new Server(){

            @Override
            public String getHost() {
                return String.format("%s:%d", this.getAddress(), this.getPort());
            }

            @Override
            public String getAddress() {
                return instance.getAddress();
            }

            @Override
            public int getPort() {
                return instance.getPort();
            }

            @Override
            public String getScheme() {
                return "http";
            }
        };
    }

    @LifecycleStart
    public void start() throws Exception {
        this.serviceProvider.start();
    }

    @LifecycleStop
    public void stop() throws IOException {
        this.serviceProvider.close();
    }
}

