/*
 * Decompiled with CFR 0.152.
 */
package io.druid.curator;

import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.metamx.common.lifecycle.Lifecycle;
import com.metamx.common.logger.Logger;
import io.druid.curator.CuratorConfig;
import io.druid.curator.PotentiallyGzippedCompressionProvider;
import io.druid.guice.ConfigProvider;
import io.druid.guice.LazySingleton;
import java.io.IOException;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.framework.api.CompressionProvider;
import org.apache.curator.retry.BoundedExponentialBackoffRetry;

public class CuratorModule
implements Module {
    private static final Logger log = new Logger(CuratorModule.class);

    public void configure(Binder binder) {
        ConfigProvider.bind((Binder)binder, CuratorConfig.class);
    }

    @Provides
    @LazySingleton
    public CuratorFramework makeCurator(CuratorConfig config, Lifecycle lifecycle) throws IOException {
        final CuratorFramework framework = CuratorFrameworkFactory.builder().connectString(config.getZkHosts()).sessionTimeoutMs(config.getZkSessionTimeoutMs()).retryPolicy((RetryPolicy)new BoundedExponentialBackoffRetry(1000, 45000, 30)).compressionProvider((CompressionProvider)new PotentiallyGzippedCompressionProvider(config.enableCompression())).build();
        lifecycle.addHandler(new Lifecycle.Handler(){

            public void start() throws Exception {
                log.info("Starting Curator", new Object[0]);
                framework.start();
            }

            public void stop() {
                log.info("Stopping Curator", new Object[0]);
                framework.close();
            }
        });
        return framework;
    }
}

