/*
 * Decompiled with CFR 0.152.
 */
package io.druid.client.selector;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.google.api.client.util.Maps;
import com.google.common.primitives.Ints;
import io.druid.client.selector.AbstractTierSelectorStrategy;
import io.druid.client.selector.CustomTierSelectorStrategyConfig;
import io.druid.client.selector.ServerSelectorStrategy;
import java.util.Comparator;
import java.util.HashMap;

public class CustomTierSelectorStrategy
extends AbstractTierSelectorStrategy {
    private final Comparator<Integer> comparator;

    @JsonCreator
    public CustomTierSelectorStrategy(@JacksonInject ServerSelectorStrategy serverSelectorStrategy, @JacksonInject CustomTierSelectorStrategyConfig config) {
        super(serverSelectorStrategy);
        final HashMap lookup = Maps.newHashMap();
        int pos = 0;
        for (Integer integer : config.getPriorities()) {
            lookup.put(integer, pos);
            ++pos;
        }
        this.comparator = new Comparator<Integer>(){

            @Override
            public int compare(Integer o1, Integer o2) {
                int pos1 = (Integer)lookup.get(o1);
                int pos2 = (Integer)lookup.get(o2);
                return Ints.compare((int)pos1, (int)pos2);
            }
        };
    }

    @Override
    public Comparator<Integer> getComparator() {
        return this.comparator;
    }
}

