/*
 * Decompiled with CFR 0.152.
 */
package io.druid.client.cache;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.primitives.Ints;
import io.druid.client.cache.ByteCountingLRUMap;
import io.druid.client.cache.Cache;
import io.druid.client.cache.CacheStats;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class MapCache
implements Cache {
    private final Map<ByteBuffer, byte[]> baseMap;
    private final ByteCountingLRUMap byteCountingLRUMap;
    private final Map<String, byte[]> namespaceId;
    private final AtomicInteger ids;
    private final Object clearLock = new Object();
    private final AtomicLong hitCount = new AtomicLong(0L);
    private final AtomicLong missCount = new AtomicLong(0L);

    public static Cache create(long sizeInBytes) {
        return new MapCache(new ByteCountingLRUMap(sizeInBytes));
    }

    MapCache(ByteCountingLRUMap byteCountingLRUMap) {
        this.byteCountingLRUMap = byteCountingLRUMap;
        this.baseMap = Collections.synchronizedMap(byteCountingLRUMap);
        this.namespaceId = Maps.newHashMap();
        this.ids = new AtomicInteger();
    }

    @Override
    public CacheStats getStats() {
        return new CacheStats(this.hitCount.get(), this.missCount.get(), this.byteCountingLRUMap.size(), this.byteCountingLRUMap.getNumBytes(), this.byteCountingLRUMap.getEvictionCount(), 0L, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] get(Cache.NamedKey key) {
        byte[] retVal;
        Object object = this.clearLock;
        synchronized (object) {
            retVal = this.baseMap.get(this.computeKey(this.getNamespaceId(key.namespace), key.key));
        }
        if (retVal == null) {
            this.missCount.incrementAndGet();
        } else {
            this.hitCount.incrementAndGet();
        }
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(Cache.NamedKey key, byte[] value) {
        Object object = this.clearLock;
        synchronized (object) {
            this.baseMap.put(this.computeKey(this.getNamespaceId(key.namespace), key.key), value);
        }
    }

    @Override
    public Map<Cache.NamedKey, byte[]> getBulk(Iterable<Cache.NamedKey> keys) {
        HashMap retVal = Maps.newHashMap();
        for (Cache.NamedKey key : keys) {
            retVal.put(key, this.get(key));
        }
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close(String namespace) {
        byte[] idBytes;
        Object object = this.namespaceId;
        synchronized (object) {
            idBytes = this.getNamespaceId(namespace);
            if (idBytes == null) {
                return;
            }
            this.namespaceId.remove(namespace);
        }
        object = this.clearLock;
        synchronized (object) {
            Iterator<ByteBuffer> iter = this.baseMap.keySet().iterator();
            LinkedList toRemove = Lists.newLinkedList();
            while (iter.hasNext()) {
                ByteBuffer next = iter.next();
                if (next.get(0) != idBytes[0] || next.get(1) != idBytes[1] || next.get(2) != idBytes[2] || next.get(3) != idBytes[3]) continue;
                toRemove.add(next);
            }
            for (ByteBuffer key : toRemove) {
                this.baseMap.remove(key);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] getNamespaceId(String identifier) {
        Map<String, byte[]> map = this.namespaceId;
        synchronized (map) {
            byte[] idBytes = this.namespaceId.get(identifier);
            if (idBytes != null) {
                return idBytes;
            }
            idBytes = Ints.toByteArray((int)this.ids.getAndIncrement());
            this.namespaceId.put(identifier, idBytes);
            return idBytes;
        }
    }

    private ByteBuffer computeKey(byte[] idBytes, byte[] key) {
        ByteBuffer retVal = ByteBuffer.allocate(key.length + 4).put(idBytes).put(key);
        retVal.rewind();
        return retVal;
    }

    @Override
    public boolean isLocal() {
        return true;
    }
}

