/*
 * Decompiled with CFR 0.152.
 */
package io.druid.client.cache;

import com.google.inject.Inject;
import com.metamx.emitter.service.ServiceEmitter;
import com.metamx.emitter.service.ServiceMetricEvent;
import com.metamx.metrics.AbstractMonitor;
import io.druid.client.cache.Cache;
import io.druid.client.cache.CacheStats;

public class CacheMonitor
extends AbstractMonitor {
    private final Cache cache;
    private volatile CacheStats prevCacheStats = null;

    @Inject
    public CacheMonitor(Cache cache) {
        this.cache = cache;
    }

    public boolean doMonitor(ServiceEmitter emitter) {
        CacheStats currCacheStats = this.cache.getStats();
        CacheStats deltaCacheStats = currCacheStats.delta(this.prevCacheStats);
        ServiceMetricEvent.Builder builder = new ServiceMetricEvent.Builder();
        this.emitStats(emitter, "cache/delta", deltaCacheStats, builder);
        this.emitStats(emitter, "cache/total", currCacheStats, builder);
        this.prevCacheStats = currCacheStats;
        return true;
    }

    private void emitStats(ServiceEmitter emitter, String metricPrefix, CacheStats cacheStats, ServiceMetricEvent.Builder builder) {
        emitter.emit(builder.build(String.format("%s/numEntries", metricPrefix), (Number)cacheStats.getNumEntries()));
        emitter.emit(builder.build(String.format("%s/sizeBytes", metricPrefix), (Number)cacheStats.getSizeInBytes()));
        emitter.emit(builder.build(String.format("%s/hits", metricPrefix), (Number)cacheStats.getNumHits()));
        emitter.emit(builder.build(String.format("%s/misses", metricPrefix), (Number)cacheStats.getNumMisses()));
        emitter.emit(builder.build(String.format("%s/evictions", metricPrefix), (Number)cacheStats.getNumEvictions()));
        emitter.emit(builder.build(String.format("%s/hitRate", metricPrefix), (Number)cacheStats.hitRate()));
        emitter.emit(builder.build(String.format("%s/averageBytes", metricPrefix), (Number)cacheStats.averageBytes()));
        emitter.emit(builder.build(String.format("%s/timeouts", metricPrefix), (Number)cacheStats.getNumTimeouts()));
        emitter.emit(builder.build(String.format("%s/errors", metricPrefix), (Number)cacheStats.getNumErrors()));
    }
}

