/*
 * Decompiled with CFR 0.152.
 */
package io.druid.client;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.api.client.repackaged.com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.MapMaker;
import com.google.inject.Inject;
import com.metamx.emitter.EmittingLogger;
import io.druid.client.DruidServer;
import io.druid.client.FilteredServerView;
import io.druid.client.ServerInventoryView;
import io.druid.client.ServerView;
import io.druid.guice.ManageLifecycle;
import io.druid.server.coordination.DruidServerMetadata;
import io.druid.server.initialization.ZkPathsConfig;
import io.druid.timeline.DataSegment;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import org.apache.curator.framework.CuratorFramework;

@ManageLifecycle
public class SingleServerInventoryView
extends ServerInventoryView<DataSegment>
implements FilteredServerView {
    private static final EmittingLogger log = new EmittingLogger(SingleServerInventoryView.class);
    private final ConcurrentMap<ServerView.SegmentCallback, Predicate<DataSegment>> segmentPredicates = new MapMaker().makeMap();
    private final Predicate<DataSegment> defaultFilter;

    @Inject
    public SingleServerInventoryView(ZkPathsConfig zkPaths, CuratorFramework curator, ObjectMapper jsonMapper, Predicate<DataSegment> defaultFilter) {
        super(log, zkPaths.getAnnouncementsPath(), zkPaths.getServedSegmentsPath(), curator, jsonMapper, new TypeReference<DataSegment>(){});
        Preconditions.checkNotNull(defaultFilter);
        this.defaultFilter = defaultFilter;
    }

    @Override
    protected DruidServer addInnerInventory(DruidServer container, String inventoryKey, DataSegment inventory) {
        Predicate predicate = Predicates.or(this.defaultFilter, (Predicate)Predicates.or(this.segmentPredicates.values()));
        if (predicate.apply((Object)inventory)) {
            this.addSingleInventory(container, inventory);
        }
        return container;
    }

    @Override
    protected DruidServer updateInnerInventory(DruidServer container, String inventoryKey, DataSegment inventory) {
        return this.addInnerInventory(container, inventoryKey, inventory);
    }

    @Override
    protected DruidServer removeInnerInventory(DruidServer container, String inventoryKey) {
        this.removeSingleInventory(container, inventoryKey);
        return container;
    }

    @Override
    public void registerSegmentCallback(Executor exec, final ServerView.SegmentCallback callback, final Predicate<DataSegment> filter) {
        this.segmentPredicates.put(callback, filter);
        this.registerSegmentCallback(exec, new ServerView.SegmentCallback(){

            @Override
            public ServerView.CallbackAction segmentAdded(DruidServerMetadata server, DataSegment segment) {
                ServerView.CallbackAction action;
                if (filter.apply((Object)segment)) {
                    action = callback.segmentAdded(server, segment);
                    if (action.equals((Object)ServerView.CallbackAction.UNREGISTER)) {
                        SingleServerInventoryView.this.segmentPredicates.remove(callback);
                    }
                } else {
                    action = ServerView.CallbackAction.CONTINUE;
                }
                return action;
            }

            @Override
            public ServerView.CallbackAction segmentRemoved(DruidServerMetadata server, DataSegment segment) {
                ServerView.CallbackAction action;
                if (filter.apply((Object)segment)) {
                    action = callback.segmentRemoved(server, segment);
                    if (action.equals((Object)ServerView.CallbackAction.UNREGISTER)) {
                        SingleServerInventoryView.this.segmentPredicates.remove(callback);
                    }
                } else {
                    action = ServerView.CallbackAction.CONTINUE;
                }
                return action;
            }
        });
    }
}

