/*
 * Decompiled with CFR 0.152.
 */
package io.druid.client;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Function;
import com.google.common.base.Throwables;
import com.google.common.collect.MapMaker;
import com.metamx.common.lifecycle.LifecycleStart;
import com.metamx.common.lifecycle.LifecycleStop;
import com.metamx.emitter.EmittingLogger;
import io.druid.client.DruidServer;
import io.druid.client.InventoryView;
import io.druid.client.ServerView;
import io.druid.concurrent.Execs;
import io.druid.curator.inventory.CuratorInventoryManager;
import io.druid.curator.inventory.CuratorInventoryManagerStrategy;
import io.druid.curator.inventory.InventoryManagerConfig;
import io.druid.timeline.DataSegment;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.curator.framework.CuratorFramework;

public abstract class ServerInventoryView<InventoryType>
implements ServerView,
InventoryView {
    private final EmittingLogger log;
    private final CuratorInventoryManager<DruidServer, InventoryType> inventoryManager;
    private final AtomicBoolean started = new AtomicBoolean(false);
    private final ConcurrentMap<ServerView.ServerCallback, Executor> serverCallbacks = new MapMaker().makeMap();
    private final ConcurrentMap<ServerView.SegmentCallback, Executor> segmentCallbacks = new MapMaker().makeMap();

    public ServerInventoryView(final EmittingLogger log, final String announcementsPath, final String inventoryPath, CuratorFramework curator, final ObjectMapper jsonMapper, final TypeReference<InventoryType> typeReference) {
        this.log = log;
        this.inventoryManager = new CuratorInventoryManager(curator, new InventoryManagerConfig(){

            @Override
            public String getContainerPath() {
                return announcementsPath;
            }

            @Override
            public String getInventoryPath() {
                return inventoryPath;
            }
        }, Execs.singleThreaded((String)"ServerInventoryView-%s"), new CuratorInventoryManagerStrategy<DruidServer, InventoryType>(){

            @Override
            public DruidServer deserializeContainer(byte[] bytes) {
                try {
                    return (DruidServer)jsonMapper.readValue(bytes, DruidServer.class);
                }
                catch (IOException e) {
                    throw Throwables.propagate((Throwable)e);
                }
            }

            @Override
            public byte[] serializeContainer(DruidServer container) {
                try {
                    return jsonMapper.writeValueAsBytes((Object)container);
                }
                catch (JsonProcessingException e) {
                    throw Throwables.propagate((Throwable)e);
                }
            }

            @Override
            public InventoryType deserializeInventory(byte[] bytes) {
                try {
                    return jsonMapper.readValue(bytes, typeReference);
                }
                catch (IOException e) {
                    throw Throwables.propagate((Throwable)e);
                }
            }

            @Override
            public byte[] serializeInventory(InventoryType inventory) {
                try {
                    return jsonMapper.writeValueAsBytes(inventory);
                }
                catch (JsonProcessingException e) {
                    throw Throwables.propagate((Throwable)e);
                }
            }

            @Override
            public void newContainer(DruidServer container) {
                log.info("New Server[%s]", new Object[]{container});
            }

            @Override
            public void deadContainer(DruidServer deadContainer) {
                log.info("Server Disappeared[%s]", new Object[]{deadContainer});
                ServerInventoryView.this.runServerCallbacks(deadContainer);
            }

            @Override
            public DruidServer updateContainer(DruidServer oldContainer, DruidServer newContainer) {
                return newContainer.addDataSegments(oldContainer);
            }

            @Override
            public DruidServer addInventory(DruidServer container, String inventoryKey, InventoryType inventory) {
                return ServerInventoryView.this.addInnerInventory(container, inventoryKey, inventory);
            }

            @Override
            public DruidServer updateInventory(DruidServer container, String inventoryKey, InventoryType inventory) {
                return ServerInventoryView.this.updateInnerInventory(container, inventoryKey, inventory);
            }

            @Override
            public DruidServer removeInventory(DruidServer container, String inventoryKey) {
                return ServerInventoryView.this.removeInnerInventory(container, inventoryKey);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @LifecycleStart
    public void start() throws Exception {
        AtomicBoolean atomicBoolean = this.started;
        synchronized (atomicBoolean) {
            if (!this.started.get()) {
                this.inventoryManager.start();
                this.started.set(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @LifecycleStop
    public void stop() throws IOException {
        AtomicBoolean atomicBoolean = this.started;
        synchronized (atomicBoolean) {
            if (this.started.getAndSet(false)) {
                this.inventoryManager.stop();
            }
        }
    }

    public boolean isStarted() {
        return this.started.get();
    }

    @Override
    public DruidServer getInventoryValue(String containerKey) {
        return this.inventoryManager.getInventoryValue(containerKey);
    }

    @Override
    public Iterable<DruidServer> getInventory() {
        return this.inventoryManager.getInventory();
    }

    @Override
    public void registerServerCallback(Executor exec, ServerView.ServerCallback callback) {
        this.serverCallbacks.put(callback, exec);
    }

    @Override
    public void registerSegmentCallback(Executor exec, ServerView.SegmentCallback callback) {
        this.segmentCallbacks.put(callback, exec);
    }

    public InventoryManagerConfig getInventoryManagerConfig() {
        return this.inventoryManager.getConfig();
    }

    protected void runSegmentCallbacks(final Function<ServerView.SegmentCallback, ServerView.CallbackAction> fn) {
        for (final Map.Entry entry : this.segmentCallbacks.entrySet()) {
            ((Executor)entry.getValue()).execute(new Runnable(){

                @Override
                public void run() {
                    if (ServerView.CallbackAction.UNREGISTER == fn.apply(entry.getKey())) {
                        ServerInventoryView.this.segmentCallbacks.remove(entry.getKey());
                    }
                }
            });
        }
    }

    protected void runServerCallbacks(final DruidServer server) {
        for (final Map.Entry entry : this.serverCallbacks.entrySet()) {
            ((Executor)entry.getValue()).execute(new Runnable(){

                @Override
                public void run() {
                    if (ServerView.CallbackAction.UNREGISTER == ((ServerView.ServerCallback)entry.getKey()).serverRemoved(server)) {
                        ServerInventoryView.this.serverCallbacks.remove(entry.getKey());
                    }
                }
            });
        }
    }

    protected void addSingleInventory(final DruidServer container, final DataSegment inventory) {
        this.log.info("Server[%s] added segment[%s]", new Object[]{container.getName(), inventory.getIdentifier()});
        if (container.getSegment(inventory.getIdentifier()) != null) {
            this.log.warn("Not adding or running callbacks for existing segment[%s] on server[%s]", new Object[]{inventory.getIdentifier(), container.getName()});
            return;
        }
        container.addDataSegment(inventory.getIdentifier(), inventory);
        this.runSegmentCallbacks(new Function<ServerView.SegmentCallback, ServerView.CallbackAction>(){

            public ServerView.CallbackAction apply(ServerView.SegmentCallback input) {
                return input.segmentAdded(container.getMetadata(), inventory);
            }
        });
    }

    protected void removeSingleInventory(final DruidServer container, String inventoryKey) {
        this.log.info("Server[%s] removed segment[%s]", new Object[]{container.getName(), inventoryKey});
        final DataSegment segment = container.getSegment(inventoryKey);
        if (segment == null) {
            this.log.warn("Not running cleanup or callbacks for non-existing segment[%s] on server[%s]", new Object[]{inventoryKey, container.getName()});
            return;
        }
        container.removeDataSegment(inventoryKey);
        this.runSegmentCallbacks(new Function<ServerView.SegmentCallback, ServerView.CallbackAction>(){

            public ServerView.CallbackAction apply(ServerView.SegmentCallback input) {
                return input.segmentRemoved(container.getMetadata(), segment);
            }
        });
    }

    protected abstract DruidServer addInnerInventory(DruidServer var1, String var2, InventoryType var3);

    protected abstract DruidServer updateInnerInventory(DruidServer var1, String var2, InventoryType var3);

    protected abstract DruidServer removeInnerInventory(DruidServer var1, String var2);
}

