/*
 * Decompiled with CFR 0.152.
 */
package io.druid.client;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.type.ResolvedType;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.fasterxml.jackson.dataformat.smile.SmileFactory;
import com.google.common.base.Charsets;
import com.google.common.base.Function;
import com.google.common.base.Throwables;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.metamx.common.IAE;
import com.metamx.common.Pair;
import com.metamx.common.RE;
import com.metamx.common.guava.BaseSequence;
import com.metamx.common.guava.CloseQuietly;
import com.metamx.common.guava.Sequence;
import com.metamx.common.guava.Sequences;
import com.metamx.common.logger.Logger;
import com.metamx.http.client.HttpClient;
import com.metamx.http.client.io.AppendableByteArrayInputStream;
import com.metamx.http.client.response.ClientResponse;
import com.metamx.http.client.response.HttpResponseHandler;
import com.metamx.http.client.response.InputStreamResponseHandler;
import com.metamx.http.client.response.StatusResponseHandler;
import com.metamx.http.client.response.StatusResponseHolder;
import io.druid.query.BySegmentResultValueClass;
import io.druid.query.Query;
import io.druid.query.QueryInterruptedException;
import io.druid.query.QueryRunner;
import io.druid.query.QueryToolChest;
import io.druid.query.QueryToolChestWarehouse;
import io.druid.query.QueryWatcher;
import io.druid.query.Result;
import io.druid.query.aggregation.MetricManipulatorFns;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import org.jboss.netty.handler.codec.http.HttpChunk;
import org.jboss.netty.handler.codec.http.HttpResponse;

public class DirectDruidClient<T>
implements QueryRunner<T> {
    private static final Logger log = new Logger(DirectDruidClient.class);
    private static final Map<Class<? extends Query>, Pair<JavaType, JavaType>> typesMap = Maps.newConcurrentMap();
    private final QueryToolChestWarehouse warehouse;
    private final QueryWatcher queryWatcher;
    private final ObjectMapper objectMapper;
    private final HttpClient httpClient;
    private final String host;
    private final AtomicInteger openConnections;
    private final boolean isSmile;

    public DirectDruidClient(QueryToolChestWarehouse warehouse, QueryWatcher queryWatcher, ObjectMapper objectMapper, HttpClient httpClient, String host) {
        this.warehouse = warehouse;
        this.queryWatcher = queryWatcher;
        this.objectMapper = objectMapper;
        this.httpClient = httpClient;
        this.host = host;
        this.isSmile = this.objectMapper.getFactory() instanceof SmileFactory;
        this.openConnections = new AtomicInteger();
    }

    public int getNumOpenConnections() {
        return this.openConnections.get();
    }

    public Sequence<T> run(final Query<T> query) {
        ListenableFuture future;
        QueryToolChest toolChest = this.warehouse.getToolChest(query);
        boolean isBySegment = query.getContextBySegment(false);
        Pair types = typesMap.get(query.getClass());
        if (types == null) {
            TypeFactory typeFactory = this.objectMapper.getTypeFactory();
            JavaType baseType = typeFactory.constructType(toolChest.getResultTypeReference());
            JavaType bySegmentType = typeFactory.constructParametricType(Result.class, new JavaType[]{typeFactory.constructParametricType(BySegmentResultValueClass.class, new JavaType[]{baseType})});
            types = Pair.of((Object)baseType, (Object)bySegmentType);
            typesMap.put(query.getClass(), (Pair<JavaType, JavaType>)types);
        }
        final JavaType typeRef = isBySegment ? (JavaType)types.rhs : (JavaType)types.lhs;
        final String url = String.format("http://%s/druid/v2/", this.host);
        final String cancelUrl = String.format("http://%s/druid/v2/%s", this.host, query.getId());
        try {
            log.debug("Querying url[%s]", new Object[]{url});
            future = this.httpClient.post(new URL(url)).setContent(this.objectMapper.writeValueAsBytes(query)).setHeader("Content-Type", (Object)(this.isSmile ? "application/smile" : "application/json")).go((HttpResponseHandler)new InputStreamResponseHandler(){
                long startTime;
                long byteCount = 0L;

                public ClientResponse<AppendableByteArrayInputStream> handleResponse(HttpResponse response) {
                    log.debug("Initial response from url[%s]", new Object[]{url});
                    this.startTime = System.currentTimeMillis();
                    this.byteCount += (long)response.getContent().readableBytes();
                    return super.handleResponse(response);
                }

                public ClientResponse<AppendableByteArrayInputStream> handleChunk(ClientResponse<AppendableByteArrayInputStream> clientResponse, HttpChunk chunk) {
                    int bytes = chunk.getContent().readableBytes();
                    this.byteCount += (long)bytes;
                    return super.handleChunk(clientResponse, chunk);
                }

                public ClientResponse<InputStream> done(ClientResponse<AppendableByteArrayInputStream> clientResponse) {
                    long stopTime = System.currentTimeMillis();
                    log.debug("Completed request to url[%s] with %,d bytes returned in %,d millis [%,f b/s].", new Object[]{url, this.byteCount, stopTime - this.startTime, (double)this.byteCount / (1.0E-4 * (double)(stopTime - this.startTime))});
                    return super.done(clientResponse);
                }
            });
            this.queryWatcher.registerQuery(query, future);
            this.openConnections.getAndIncrement();
            Futures.addCallback((ListenableFuture)future, (FutureCallback)new FutureCallback<InputStream>(){

                public void onSuccess(InputStream result) {
                    DirectDruidClient.this.openConnections.getAndDecrement();
                }

                public void onFailure(Throwable t) {
                    DirectDruidClient.this.openConnections.getAndDecrement();
                    if (future.isCancelled()) {
                        try {
                            StatusResponseHolder res = (StatusResponseHolder)DirectDruidClient.this.httpClient.delete(new URL(cancelUrl)).setContent(DirectDruidClient.this.objectMapper.writeValueAsBytes((Object)query)).setHeader("Content-Type", (Object)(DirectDruidClient.this.isSmile ? "application/smile" : "application/json")).go((HttpResponseHandler)new StatusResponseHandler(Charsets.UTF_8)).get();
                            if (res.getStatus().getCode() >= 500) {
                                throw new RE("Error cancelling query[%s]: queriable node returned status[%d] [%s].", new Object[]{res.getStatus().getCode(), res.getStatus().getReasonPhrase()});
                            }
                        }
                        catch (IOException | InterruptedException | ExecutionException e) {
                            Throwables.propagate((Throwable)e);
                        }
                    }
                }
            });
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
        BaseSequence retVal = new BaseSequence(new BaseSequence.IteratorMaker<T, JsonParserIterator<T>>(){

            public JsonParserIterator<T> make() {
                return new JsonParserIterator(typeRef, (Future<InputStream>)future, url);
            }

            public void cleanup(JsonParserIterator<T> iterFromMake) {
                CloseQuietly.close(iterFromMake);
            }
        });
        if (!isBySegment) {
            retVal = Sequences.map((Sequence)retVal, (Function)toolChest.makePreComputeManipulatorFn(query, MetricManipulatorFns.deserializing()));
        }
        return retVal;
    }

    private class JsonParserIterator<T>
    implements Iterator<T>,
    Closeable {
        private JsonParser jp;
        private ObjectCodec objectCodec;
        private final JavaType typeRef;
        private final Future<InputStream> future;
        private final String url;

        public JsonParserIterator(JavaType typeRef, Future<InputStream> future, String url) {
            this.typeRef = typeRef;
            this.future = future;
            this.url = url;
            this.jp = null;
        }

        @Override
        public boolean hasNext() {
            this.init();
            if (this.jp.isClosed()) {
                return false;
            }
            if (this.jp.getCurrentToken() == JsonToken.END_ARRAY) {
                CloseQuietly.close((Closeable)this.jp);
                return false;
            }
            return true;
        }

        @Override
        public T next() {
            this.init();
            try {
                Object retVal = this.objectCodec.readValue(this.jp, (ResolvedType)this.typeRef);
                this.jp.nextToken();
                return (T)retVal;
            }
            catch (IOException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private void init() {
            if (this.jp == null) {
                try {
                    this.jp = DirectDruidClient.this.objectMapper.getFactory().createParser(this.future.get());
                    JsonToken nextToken = this.jp.nextToken();
                    if (nextToken == JsonToken.START_OBJECT) {
                        QueryInterruptedException e = (QueryInterruptedException)this.jp.getCodec().readValue(this.jp, QueryInterruptedException.class);
                        throw e;
                    }
                    if (nextToken != JsonToken.START_ARRAY) {
                        throw new IAE("Next token wasn't a START_ARRAY, was[%s] from url [%s]", new Object[]{this.jp.getCurrentToken(), this.url});
                    }
                    this.jp.nextToken();
                    this.objectCodec = this.jp.getCodec();
                }
                catch (IOException | InterruptedException | ExecutionException e) {
                    throw new RE((Throwable)e, "Failure getting results from[%s]", new Object[]{this.url});
                }
                catch (CancellationException e) {
                    throw new QueryInterruptedException("Query cancelled");
                }
            }
        }

        @Override
        public void close() throws IOException {
            if (this.jp != null) {
                this.jp.close();
            }
        }
    }
}

