/*
 * Decompiled with CFR 0.152.
 */
package io.druid.client;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Function;
import com.google.common.base.Throwables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.MoreExecutors;
import com.metamx.common.guava.BaseSequence;
import com.metamx.common.guava.Sequence;
import com.metamx.common.guava.Sequences;
import io.druid.client.CacheUtil;
import io.druid.client.cache.Cache;
import io.druid.client.cache.CacheConfig;
import io.druid.query.CacheStrategy;
import io.druid.query.Query;
import io.druid.query.QueryRunner;
import io.druid.query.QueryToolChest;
import io.druid.query.SegmentDescriptor;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.concurrent.Executor;

public class CachingQueryRunner<T>
implements QueryRunner<T> {
    private final String segmentIdentifier;
    private final SegmentDescriptor segmentDescriptor;
    private final QueryRunner<T> base;
    private final QueryToolChest toolChest;
    private final Cache cache;
    private final ObjectMapper mapper;
    private final CacheConfig cacheConfig;

    public CachingQueryRunner(String segmentIdentifier, SegmentDescriptor segmentDescriptor, ObjectMapper mapper, Cache cache, QueryToolChest toolchest, QueryRunner<T> base, CacheConfig cacheConfig) {
        this.base = base;
        this.segmentIdentifier = segmentIdentifier;
        this.segmentDescriptor = segmentDescriptor;
        this.toolChest = toolchest;
        this.cache = cache;
        this.mapper = mapper;
        this.cacheConfig = cacheConfig;
    }

    public Sequence<T> run(Query<T> query) {
        Function cacheFn;
        CacheStrategy strategy = this.toolChest.getCacheStrategy(query);
        boolean populateCache = query.getContextPopulateCache(true) && strategy != null && this.cacheConfig.isPopulateCache() && this.cacheConfig.isQueryCacheable(query);
        boolean useCache = query.getContextUseCache(true) && strategy != null && this.cacheConfig.isUseCache() && this.cacheConfig.isQueryCacheable(query);
        final Cache.NamedKey key = strategy != null && (useCache || populateCache) ? CacheUtil.computeSegmentCacheKey(this.segmentIdentifier, this.segmentDescriptor, strategy.computeCacheKey(query)) : null;
        if (useCache) {
            cacheFn = strategy.pullFromCache();
            final byte[] cachedResult = this.cache.get(key);
            if (cachedResult != null) {
                final TypeReference cacheObjectClazz = strategy.getCacheObjectClazz();
                return Sequences.map((Sequence)new BaseSequence(new BaseSequence.IteratorMaker<T, Iterator<T>>(){

                    public Iterator<T> make() {
                        try {
                            if (cachedResult.length == 0) {
                                return Iterators.emptyIterator();
                            }
                            return CachingQueryRunner.this.mapper.readValues(CachingQueryRunner.this.mapper.getFactory().createParser(cachedResult), cacheObjectClazz);
                        }
                        catch (IOException e) {
                            throw Throwables.propagate((Throwable)e);
                        }
                    }

                    public void cleanup(Iterator<T> iterFromMake) {
                    }
                }), (Function)cacheFn);
            }
        }
        if (populateCache) {
            cacheFn = strategy.prepareForCache();
            final LinkedList cacheResults = Lists.newLinkedList();
            return Sequences.withEffect((Sequence)Sequences.map((Sequence)this.base.run(query), (Function)new Function<T, T>(){

                public T apply(T input) {
                    cacheResults.add(cacheFn.apply(input));
                    return input;
                }
            }), (Runnable)new Runnable(){

                @Override
                public void run() {
                    CacheUtil.populate(CachingQueryRunner.this.cache, CachingQueryRunner.this.mapper, key, cacheResults);
                }
            }, (Executor)MoreExecutors.sameThreadExecutor());
        }
        return this.base.run(query);
    }
}

