/*
 * Decompiled with CFR 0.152.
 */
package io.druid.client;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.inject.Inject;
import com.metamx.common.Pair;
import com.metamx.common.guava.BaseSequence;
import com.metamx.common.guava.LazySequence;
import com.metamx.common.guava.Sequence;
import com.metamx.common.guava.Sequences;
import com.metamx.emitter.EmittingLogger;
import io.druid.client.CacheUtil;
import io.druid.client.DruidServer;
import io.druid.client.ServerView;
import io.druid.client.TimelineServerView;
import io.druid.client.cache.Cache;
import io.druid.client.cache.CacheConfig;
import io.druid.client.selector.QueryableDruidServer;
import io.druid.client.selector.ServerSelector;
import io.druid.guice.annotations.Smile;
import io.druid.query.BySegmentResultValueClass;
import io.druid.query.CacheStrategy;
import io.druid.query.Query;
import io.druid.query.QueryRunner;
import io.druid.query.QueryToolChest;
import io.druid.query.QueryToolChestWarehouse;
import io.druid.query.Result;
import io.druid.query.SegmentDescriptor;
import io.druid.query.aggregation.MetricManipulatorFns;
import io.druid.query.spec.MultipleSpecificSegmentSpec;
import io.druid.query.spec.QuerySegmentSpec;
import io.druid.server.coordination.DruidServerMetadata;
import io.druid.timeline.DataSegment;
import io.druid.timeline.TimelineObjectHolder;
import io.druid.timeline.VersionedIntervalTimeline;
import io.druid.timeline.partition.PartitionChunk;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.joda.time.DateTime;
import org.joda.time.Interval;

public class CachingClusteredClient<T>
implements QueryRunner<T> {
    private static final EmittingLogger log = new EmittingLogger(CachingClusteredClient.class);
    private final QueryToolChestWarehouse warehouse;
    private final TimelineServerView serverView;
    private final Cache cache;
    private final ObjectMapper objectMapper;
    private final CacheConfig cacheConfig;

    @Inject
    public CachingClusteredClient(QueryToolChestWarehouse warehouse, TimelineServerView serverView, Cache cache, @Smile ObjectMapper objectMapper, CacheConfig cacheConfig) {
        this.warehouse = warehouse;
        this.serverView = serverView;
        this.cache = cache;
        this.objectMapper = objectMapper;
        this.cacheConfig = cacheConfig;
        serverView.registerSegmentCallback(Executors.newFixedThreadPool(1, new ThreadFactoryBuilder().setDaemon(true).setNameFormat("CCClient-ServerView-CB-%d").build()), new ServerView.BaseSegmentCallback(){

            @Override
            public ServerView.CallbackAction segmentRemoved(DruidServerMetadata server, DataSegment segment) {
                CachingClusteredClient.this.cache.close(segment.getIdentifier());
                return ServerView.CallbackAction.CONTINUE;
            }
        });
    }

    public Sequence<T> run(final Query<T> query) {
        final QueryToolChest toolChest = this.warehouse.getToolChest(query);
        final CacheStrategy strategy = toolChest.getCacheStrategy(query);
        final TreeMap serverSegments = Maps.newTreeMap();
        final ArrayList cachedResults = Lists.newArrayList();
        final HashMap cachePopulatorMap = Maps.newHashMap();
        boolean useCache = query.getContextUseCache(true) && strategy != null && this.cacheConfig.isUseCache() && this.cacheConfig.isQueryCacheable(query);
        final boolean populateCache = query.getContextPopulateCache(true) && strategy != null && this.cacheConfig.isPopulateCache() && this.cacheConfig.isQueryCacheable(query);
        final boolean isBySegment = query.getContextBySegment(false);
        ImmutableMap.Builder contextBuilder = new ImmutableMap.Builder();
        int priority = query.getContextPriority(0);
        contextBuilder.put((Object)"priority", (Object)priority);
        if (populateCache) {
            contextBuilder.put((Object)CacheConfig.POPULATE_CACHE, (Object)false);
            contextBuilder.put((Object)"bySegment", (Object)true);
        }
        contextBuilder.put((Object)"intermediate", (Object)true);
        final Query rewrittenQuery = query.withOverriddenContext((Map)contextBuilder.build());
        VersionedIntervalTimeline<String, ServerSelector> timeline = this.serverView.getTimeline(query.getDataSource());
        if (timeline == null) {
            return Sequences.empty();
        }
        LinkedHashSet segments = Sets.newLinkedHashSet();
        LinkedList serversLookup = Lists.newLinkedList();
        for (Interval interval : rewrittenQuery.getIntervals()) {
            serversLookup.addAll(timeline.lookup(interval));
        }
        List filteredServersLookup = toolChest.filterSegments(query, (List)serversLookup);
        for (TimelineObjectHolder holder : filteredServersLookup) {
            for (PartitionChunk chunk : holder.getObject()) {
                ServerSelector selector = (ServerSelector)chunk.getObject();
                SegmentDescriptor descriptor = new SegmentDescriptor(holder.getInterval(), (String)holder.getVersion(), chunk.getChunkNumber());
                segments.add(Pair.of((Object)selector, (Object)descriptor));
            }
        }
        byte[] queryCacheKey = strategy != null ? strategy.computeCacheKey(query) : null;
        if (queryCacheKey != null) {
            LinkedHashMap cacheKeys = Maps.newLinkedHashMap();
            for (Pair segment : segments) {
                Cache.NamedKey segmentCacheKey = CacheUtil.computeSegmentCacheKey(((ServerSelector)segment.lhs).getSegment().getIdentifier(), (SegmentDescriptor)segment.rhs, queryCacheKey);
                cacheKeys.put(segment, segmentCacheKey);
            }
            Map<Cache.NamedKey, Object> cachedValues = useCache ? this.cache.getBulk(cacheKeys.values()) : ImmutableMap.of();
            for (Map.Entry entry : cacheKeys.entrySet()) {
                Pair segment = (Pair)entry.getKey();
                Cache.NamedKey segmentCacheKey = (Cache.NamedKey)entry.getValue();
                Interval segmentQueryInterval = ((SegmentDescriptor)segment.rhs).getInterval();
                byte[] cachedValue = (byte[])cachedValues.get(segmentCacheKey);
                if (cachedValue != null) {
                    segments.remove(segment);
                    cachedResults.add(Pair.of((Object)segmentQueryInterval.getStart(), (Object)cachedValue));
                    continue;
                }
                if (!populateCache) continue;
                String segmentIdentifier = ((ServerSelector)segment.lhs).getSegment().getIdentifier();
                cachePopulatorMap.put(String.format("%s_%s", segmentIdentifier, segmentQueryInterval), new CachePopulator(this.cache, this.objectMapper, segmentCacheKey));
            }
        }
        for (Pair segment : segments) {
            QueryableDruidServer queryableDruidServer = ((ServerSelector)segment.lhs).pick();
            if (queryableDruidServer == null) {
                log.makeAlert("No servers found for %s?! How can this be?!", new Object[]{segment.rhs}).emit();
                continue;
            }
            DruidServer server = queryableDruidServer.getServer();
            List descriptors = (List)serverSegments.get(server);
            if (descriptors == null) {
                descriptors = Lists.newArrayList();
                serverSegments.put(server, descriptors);
            }
            descriptors.add(segment.rhs);
        }
        return new LazySequence(new Supplier<Sequence<T>>(){

            public Sequence<T> get() {
                ArrayList listOfSequences = Lists.newArrayList();
                this.addSequencesFromServer(listOfSequences);
                this.addSequencesFromCache(listOfSequences);
                Collections.sort(listOfSequences, Ordering.natural().onResultOf(Pair.lhsFn()));
                Sequence seq = Sequences.simple((Iterable)Iterables.transform((Iterable)listOfSequences, (Function)Pair.rhsFn()));
                if (strategy == null) {
                    return toolChest.mergeSequences(seq);
                }
                return strategy.mergeSequences(seq);
            }

            private void addSequencesFromCache(ArrayList<Pair<DateTime, Sequence<T>>> listOfSequences) {
                if (strategy == null) {
                    return;
                }
                Function pullFromCacheFunction = strategy.pullFromCache();
                final TypeReference cacheObjectClazz = strategy.getCacheObjectClazz();
                for (Pair cachedResultPair : cachedResults) {
                    final byte[] cachedResult = (byte[])cachedResultPair.rhs;
                    BaseSequence cachedSequence = new BaseSequence((BaseSequence.IteratorMaker)new BaseSequence.IteratorMaker<Object, Iterator<Object>>(){

                        public Iterator<Object> make() {
                            try {
                                if (cachedResult.length == 0) {
                                    return Iterators.emptyIterator();
                                }
                                return CachingClusteredClient.this.objectMapper.readValues(CachingClusteredClient.this.objectMapper.getFactory().createParser(cachedResult), cacheObjectClazz);
                            }
                            catch (IOException e) {
                                throw Throwables.propagate((Throwable)e);
                            }
                        }

                        public void cleanup(Iterator<Object> iterFromMake) {
                        }
                    });
                    listOfSequences.add(Pair.of((Object)cachedResultPair.lhs, (Object)Sequences.map((Sequence)cachedSequence, (Function)pullFromCacheFunction)));
                }
            }

            private void addSequencesFromServer(ArrayList<Pair<DateTime, Sequence<T>>> listOfSequences) {
                for (Map.Entry entry : serverSegments.entrySet()) {
                    DruidServer server = (DruidServer)entry.getKey();
                    List descriptors = (List)entry.getValue();
                    QueryRunner clientQueryable = CachingClusteredClient.this.serverView.getQueryRunner(server);
                    if (clientQueryable == null) {
                        log.makeAlert("WTF!? server[%s] doesn't have a client Queryable?", new Object[]{server}).emit();
                        continue;
                    }
                    MultipleSpecificSegmentSpec segmentSpec = new MultipleSpecificSegmentSpec(descriptors);
                    List intervals = segmentSpec.getIntervals();
                    Sequence resultSeqToAdd = !server.isAssignable() || !populateCache || isBySegment ? clientQueryable.run(query.withQuerySegmentSpec((QuerySegmentSpec)segmentSpec)) : toolChest.mergeSequences(Sequences.map((Sequence)clientQueryable.run(rewrittenQuery.withQuerySegmentSpec((QuerySegmentSpec)segmentSpec)), (Function)new Function<Object, Sequence<T>>(){
                        private final Function<T, Object> cacheFn;
                        {
                            this.cacheFn = strategy.prepareForCache();
                        }

                        public Sequence<T> apply(Object input) {
                            Result result = (Result)input;
                            final BySegmentResultValueClass value = (BySegmentResultValueClass)result.getValue();
                            final LinkedList cacheData = Lists.newLinkedList();
                            return Sequences.withEffect((Sequence)Sequences.map((Sequence)Sequences.map((Sequence)Sequences.simple((Iterable)value.getResults()), (Function)new Function<T, T>(){

                                public T apply(T input) {
                                    cacheData.add(cacheFn.apply(input));
                                    return input;
                                }
                            }), (Function)toolChest.makePreComputeManipulatorFn(rewrittenQuery, MetricManipulatorFns.deserializing())), (Runnable)new Runnable(){

                                @Override
                                public void run() {
                                    CachePopulator cachePopulator = (CachePopulator)cachePopulatorMap.get(String.format("%s_%s", value.getSegmentId(), value.getInterval()));
                                    if (cachePopulator != null) {
                                        cachePopulator.populate(cacheData);
                                    }
                                }
                            }, (Executor)MoreExecutors.sameThreadExecutor());
                        }
                    }));
                    listOfSequences.add(Pair.of((Object)((Interval)intervals.get(0)).getStart(), (Object)resultSeqToAdd));
                }
            }
        });
    }

    private static class CachePopulator {
        private final Cache cache;
        private final ObjectMapper mapper;
        private final Cache.NamedKey key;

        public CachePopulator(Cache cache, ObjectMapper mapper, Cache.NamedKey key) {
            this.cache = cache;
            this.mapper = mapper;
            this.key = key;
        }

        public void populate(Iterable<Object> results) {
            CacheUtil.populate(this.cache, this.mapper, this.key, results);
        }
    }
}

